/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.driver;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.config.Credentials;
import org.neo4j.ogm.config.UsernamePasswordCredentials;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.drivers.bolt.request.BoltRequest;
import org.neo4j.ogm.drivers.bolt.transaction.BoltTransaction;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltDriver
extends AbstractConfigurableDriver {
    private final Logger LOGGER = LoggerFactory.getLogger(BoltDriver.class);
    private volatile Driver boltDriver;
    private Credentials credentials;
    private Config driverConfig;
    private Configuration configuration;

    public BoltDriver() {
    }

    public BoltDriver(Driver boltDriver) {
        this.boltDriver = Objects.requireNonNull(boltDriver);
    }

    public void configure(Configuration config) {
        this.close();
        super.configure(config);
        this.configuration = config;
        this.driverConfig = this.buildDriverConfig(config);
        this.credentials = config.getCredentials();
        if (config.getVerifyConnection().booleanValue()) {
            this.checkDriverInitialized();
        }
    }

    public org.neo4j.ogm.transaction.Transaction newTransaction(Transaction.Type type, Iterable<String> bookmarks) {
        this.checkDriverInitialized();
        Session session = this.newSession(type, bookmarks);
        return new BoltTransaction(this.transactionManager, this.nativeTransaction(session), session, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDriverInitialized() {
        Driver driver = this.boltDriver;
        if (driver == null) {
            BoltDriver boltDriver = this;
            synchronized (boltDriver) {
                driver = this.boltDriver;
                if (driver == null) {
                    this.initializeDriver();
                }
            }
        }
    }

    private void initializeDriver() {
        block5: {
            try {
                if (this.credentials != null) {
                    UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)this.credentials;
                    AuthToken authToken = AuthTokens.basic((String)credentials.getUsername(), (String)credentials.getPassword());
                    this.boltDriver = this.createDriver(this.configuration, this.driverConfig, authToken);
                    break block5;
                }
                try {
                    this.boltDriver = this.createDriver(this.configuration, this.driverConfig, AuthTokens.none());
                }
                catch (ServiceUnavailableException e) {
                    throw new ConnectionException("Could not create driver instance.", (Throwable)e);
                }
                this.LOGGER.debug("Bolt Driver credentials not supplied");
            }
            catch (ServiceUnavailableException e) {
                throw new ConnectionException("Could not create driver instance", (Throwable)e);
            }
        }
    }

    private Driver createDriver(Configuration config, Config driverConfig, AuthToken authToken) {
        if (config.getURIS() == null) {
            return GraphDatabase.driver((String)config.getURI(), (AuthToken)authToken, (Config)driverConfig);
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        uris.add(URI.create(config.getURI()));
        for (String additionalURI : config.getURIS()) {
            uris.add(URI.create(additionalURI));
        }
        return GraphDatabase.routingDriver(uris, (AuthToken)authToken, (Config)driverConfig);
    }

    public synchronized void close() {
        if (this.boltDriver != null) {
            try {
                this.LOGGER.info("Shutting down Bolt driver {} ", (Object)this.boltDriver);
                this.boltDriver.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Request request() {
        return new BoltRequest(this.transactionManager);
    }

    private Session newSession(Transaction.Type type, Iterable<String> bookmarks) {
        Session boltSession;
        try {
            AccessMode accessMode = type.equals((Object)Transaction.Type.READ_ONLY) ? AccessMode.READ : AccessMode.WRITE;
            boltSession = this.boltDriver.session(accessMode, bookmarks);
        }
        catch (ClientException ce) {
            throw new ConnectionException("Error connecting to graph database using Bolt: " + ce.code() + ", " + ce.getMessage(), (Throwable)ce);
        }
        catch (Exception e) {
            throw new ConnectionException("Error connecting to graph database using Bolt", (Throwable)e);
        }
        return boltSession;
    }

    private Transaction nativeTransaction(Session session) {
        Transaction nativeTransaction;
        org.neo4j.ogm.transaction.Transaction tx = this.transactionManager.getCurrentTransaction();
        if (tx != null) {
            this.LOGGER.debug("Using current transaction: {}", (Object)tx);
            nativeTransaction = ((BoltTransaction)tx).nativeBoltTransaction();
        } else {
            this.LOGGER.debug("No current transaction, starting a new one");
            nativeTransaction = session.beginTransaction();
        }
        this.LOGGER.debug("Native transaction: {}", (Object)nativeTransaction);
        return nativeTransaction;
    }

    private BoltConfig getBoltConfiguration(Configuration configuration) {
        BoltConfig boltConfig = new BoltConfig();
        if (configuration.getEncryptionLevel() != null) {
            try {
                boltConfig.encryptionLevel = Config.EncryptionLevel.valueOf((String)configuration.getEncryptionLevel().toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                this.LOGGER.debug("Invalid configuration for the Bolt Driver Encryption Level: {}", (Object)configuration.getEncryptionLevel());
                throw iae;
            }
        }
        boltConfig.sessionPoolSize = configuration.getConnectionPoolSize();
        if (configuration.getTrustStrategy() != null) {
            try {
                boltConfig.trustStrategy = Config.TrustStrategy.Strategy.valueOf((String)configuration.getTrustStrategy());
            }
            catch (IllegalArgumentException iae) {
                this.LOGGER.debug("Invalid configuration for the Bolt Driver Trust Strategy: {}", (Object)configuration.getTrustStrategy());
                throw iae;
            }
        }
        if (configuration.getTrustCertFile() != null) {
            boltConfig.trustCertFile = configuration.getTrustCertFile();
        }
        if (configuration.getConnectionLivenessCheckTimeout() != null) {
            boltConfig.connectionLivenessCheckTimeout = configuration.getConnectionLivenessCheckTimeout();
        }
        return boltConfig;
    }

    private Config buildDriverConfig(Configuration driverConfig) {
        try {
            BoltConfig boltConfig = this.getBoltConfiguration(driverConfig);
            Config.ConfigBuilder configBuilder = Config.build();
            configBuilder.withMaxSessions(boltConfig.sessionPoolSize);
            if (boltConfig.encryptionLevel.equals((Object)Config.EncryptionLevel.REQUIRED)) {
                configBuilder.withEncryption();
            } else {
                configBuilder.withoutEncryption();
            }
            if (boltConfig.trustStrategy != null) {
                if (boltConfig.trustCertFile == null) {
                    throw new IllegalArgumentException("Missing configuration value for trust.certificate.file");
                }
                if (boltConfig.trustStrategy.equals((Object)Config.TrustStrategy.Strategy.TRUST_ON_FIRST_USE)) {
                    configBuilder.withTrustStrategy(Config.TrustStrategy.trustOnFirstUse((File)new File(new URI(boltConfig.trustCertFile))));
                }
                if (boltConfig.trustStrategy.equals((Object)Config.TrustStrategy.Strategy.TRUST_SIGNED_CERTIFICATES)) {
                    configBuilder.withTrustStrategy(Config.TrustStrategy.trustSignedBy((File)new File(new URI(boltConfig.trustCertFile))));
                }
            }
            if (boltConfig.connectionLivenessCheckTimeout != null) {
                configBuilder.withConnectionLivenessCheckTimeout((long)boltConfig.connectionLivenessCheckTimeout.intValue(), TimeUnit.MILLISECONDS);
            }
            return configBuilder.toConfig();
        }
        catch (Exception e) {
            throw new ConnectionException("Unable to build driver configuration", (Throwable)e);
        }
    }

    class BoltConfig {
        public static final int DEFAULT_SESSION_POOL_SIZE = 50;
        Config.EncryptionLevel encryptionLevel = Config.EncryptionLevel.REQUIRED;
        int sessionPoolSize = 50;
        Config.TrustStrategy.Strategy trustStrategy;
        String trustCertFile;
        Integer connectionLivenessCheckTimeout;

        BoltConfig() {
        }
    }
}

