/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.response;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.v1.types.Entity;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.driver.v1.types.Relationship;

class BoltEntityAdapter {
    BoltEntityAdapter() {
    }

    boolean isPath(Object value) {
        return value instanceof Path;
    }

    boolean isNode(Object value) {
        return value instanceof Node;
    }

    boolean isRelationship(Object value) {
        return value instanceof Relationship;
    }

    public long nodeId(Object node) {
        return ((Node)node).id();
    }

    public List<String> labels(Object value) {
        Node node = (Node)value;
        ArrayList<String> labels = new ArrayList<String>();
        for (String label : node.labels()) {
            labels.add(label);
        }
        return labels;
    }

    public long relationshipId(Object relationship) {
        return ((Relationship)relationship).id();
    }

    public String relationshipType(Object relationship) {
        return ((Relationship)relationship).type();
    }

    public Long startNodeId(Object relationship) {
        return ((Relationship)relationship).startNodeId();
    }

    public Long endNodeId(Object relationship) {
        return ((Relationship)relationship).endNodeId();
    }

    public Map<String, Object> properties(Object container) {
        return ((Entity)container).asMap();
    }

    List<Object> nodesInPath(Object pathValue) {
        Path path = (Path)pathValue;
        ArrayList<Object> nodes = new ArrayList<Object>(path.length());
        for (Node node : path.nodes()) {
            nodes.add(node);
        }
        return nodes;
    }

    List<Object> relsInPath(Object pathValue) {
        Path path = (Path)pathValue;
        ArrayList<Object> rels = new ArrayList<Object>(path.length());
        for (Relationship rel : path.relationships()) {
            rels.add(rel);
        }
        return rels;
    }
}

