/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.driver;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.config.Credentials;
import org.neo4j.ogm.config.UsernamePasswordCredentials;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.driver.ParameterConversion;
import org.neo4j.ogm.driver.ParameterConversionMode;
import org.neo4j.ogm.drivers.bolt.driver.JavaDriverBasedParameterConversion;
import org.neo4j.ogm.drivers.bolt.request.BoltRequest;
import org.neo4j.ogm.drivers.bolt.transaction.BoltTransaction;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltDriver
extends AbstractConfigurableDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoltDriver.class);
    public static final String CONFIG_PARAMETER_BOLT_LOGGING = "Bolt_Logging";
    private volatile Driver boltDriver;
    private Credentials credentials;
    private Config driverConfig;
    private Configuration configuration;

    public BoltDriver() {
    }

    public BoltDriver(Driver boltDriver) {
        this(boltDriver, Collections::emptyMap);
    }

    public BoltDriver(Driver boltDriver, Supplier<Map<String, Object>> customPropertiesSupplier) {
        super(customPropertiesSupplier);
        this.boltDriver = Objects.requireNonNull(boltDriver);
    }

    public void configure(Configuration config) {
        this.close();
        super.configure(config);
        this.configuration = config;
        this.driverConfig = this.buildDriverConfig(config);
        this.credentials = config.getCredentials();
        if (config.getVerifyConnection().booleanValue()) {
            this.checkDriverInitialized();
        }
    }

    public Function<TransactionManager, BiFunction<Transaction.Type, Iterable<String>, Transaction>> getTransactionFactorySupplier() {
        return transactionManager -> (type, bookmarks) -> {
            this.checkDriverInitialized();
            Session session = this.newSession((Transaction.Type)type, (Iterable<String>)bookmarks);
            return new BoltTransaction((TransactionManager)transactionManager, session, (Transaction.Type)type);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDriverInitialized() {
        Driver driver = this.boltDriver;
        if (driver == null) {
            BoltDriver boltDriver = this;
            synchronized (boltDriver) {
                driver = this.boltDriver;
                if (driver == null) {
                    this.initializeDriver();
                }
            }
        }
    }

    private void initializeDriver() {
        block5: {
            String serviceUnavailableMessage = "Could not create driver instance";
            try {
                if (this.credentials != null) {
                    UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)this.credentials;
                    AuthToken authToken = AuthTokens.basic((String)credentials.getUsername(), (String)credentials.getPassword());
                    this.boltDriver = this.createDriver(authToken);
                    break block5;
                }
                try {
                    this.boltDriver = this.createDriver(AuthTokens.none());
                }
                catch (ServiceUnavailableException e) {
                    throw new ConnectionException("Could not create driver instance", (Throwable)e);
                }
                LOGGER.debug("Bolt Driver credentials not supplied");
            }
            catch (ServiceUnavailableException e) {
                throw new ConnectionException("Could not create driver instance", (Throwable)e);
            }
        }
    }

    private Driver createDriver(AuthToken authToken) {
        if (this.isRoutingConfig()) {
            return GraphDatabase.routingDriver(this.getMergedURIs(), (AuthToken)authToken, (Config)this.driverConfig);
        }
        return GraphDatabase.driver((URI)this.getSingleURI(), (AuthToken)authToken, (Config)this.driverConfig);
    }

    private boolean isRoutingConfig() {
        String[] uris = this.configuration.getURIS();
        String uri = this.configuration.getURI();
        return uris != null && (uri == null && uris.length > 1 || uri != null && uris.length >= 1);
    }

    private List<URI> getMergedURIs() {
        ArrayList<URI> mergedUris = new ArrayList<URI>();
        String uri = this.configuration.getURI();
        String[] uris = this.configuration.getURIS();
        if (uri != null) {
            mergedUris.add(URI.create(uri));
        }
        if (uris != null) {
            for (String routingUri : uris) {
                mergedUris.add(URI.create(routingUri));
            }
        }
        return mergedUris;
    }

    private URI getSingleURI() {
        if (this.configuration.getURI() != null) {
            return URI.create(this.configuration.getURI());
        }
        String[] uris = this.configuration.getURIS();
        if (uris == null || this.configuration.getURIS().length == 0) {
            throw new IllegalArgumentException("You must provide either an URI or at least one URI in the URIS parameter.");
        }
        return URI.create(this.configuration.getURIS()[0]);
    }

    public synchronized void close() {
        if (this.boltDriver != null) {
            try {
                LOGGER.info("Shutting down Bolt driver {} ", (Object)this.boltDriver);
                this.boltDriver.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Request request(Transaction transaction) {
        return new BoltRequest(transaction, this.getParameterConversion(), this.getCypherModification());
    }

    private ParameterConversion getParameterConversion() {
        ParameterConversionMode mode = ((Map)this.customPropertiesSupplier.get()).getOrDefault(ParameterConversionMode.CONFIG_PARAMETER_CONVERSION_MODE, ParameterConversionMode.CONVERT_ALL);
        switch (mode) {
            case CONVERT_ALL: {
                return AbstractConfigurableDriver.CONVERT_ALL_PARAMETERS_CONVERSION;
            }
            case CONVERT_NON_NATIVE_ONLY: {
                return JavaDriverBasedParameterConversion.INSTANCE;
            }
        }
        throw new IllegalStateException("Unsupported conversion mode: " + mode.name() + " for Bolt-Transport.");
    }

    private Session newSession(Transaction.Type type, Iterable<String> bookmarks) {
        Session boltSession;
        try {
            AccessMode accessMode = type.equals((Object)Transaction.Type.READ_ONLY) ? AccessMode.READ : AccessMode.WRITE;
            boltSession = this.boltDriver.session(accessMode, bookmarks);
        }
        catch (ClientException ce) {
            throw new ConnectionException("Error connecting to graph database using Bolt: " + ce.code() + ", " + ce.getMessage(), (Throwable)ce);
        }
        catch (Exception e) {
            throw new ConnectionException("Error connecting to graph database using Bolt", (Throwable)e);
        }
        return boltSession;
    }

    private Optional<Logging> getBoltLogging() throws Exception {
        Object possibleLogging = ((Map)this.customPropertiesSupplier.get()).get(CONFIG_PARAMETER_BOLT_LOGGING);
        if (possibleLogging != null && !(possibleLogging instanceof Logging)) {
            LOGGER.warn("Invalid object of type {} for {}, not changing log.", possibleLogging.getClass(), (Object)CONFIG_PARAMETER_BOLT_LOGGING);
            possibleLogging = null;
        }
        LOGGER.debug("Using {} for bolt logging.", possibleLogging == null ? "default" : possibleLogging.getClass());
        return Optional.ofNullable((Logging)possibleLogging);
    }

    private Config buildDriverConfig(Configuration ogmConfig) {
        try {
            Config.ConfigBuilder configBuilder = Config.build();
            configBuilder.withMaxSessions(ogmConfig.getConnectionPoolSize());
            Config.EncryptionLevel encryptionLevel = Config.EncryptionLevel.REQUIRED;
            if (ogmConfig.getEncryptionLevel() != null) {
                try {
                    encryptionLevel = Config.EncryptionLevel.valueOf((String)ogmConfig.getEncryptionLevel().toUpperCase());
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.debug("Invalid configuration for the Bolt Driver Encryption Level: {}", (Object)ogmConfig.getEncryptionLevel());
                    throw iae;
                }
            }
            if (encryptionLevel == Config.EncryptionLevel.REQUIRED) {
                configBuilder.withEncryption();
            } else {
                configBuilder.withoutEncryption();
            }
            if (ogmConfig.getTrustStrategy() != null) {
                Config.TrustStrategy.Strategy trustStrategy;
                try {
                    trustStrategy = Config.TrustStrategy.Strategy.valueOf((String)ogmConfig.getTrustStrategy());
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.debug("Invalid configuration for the Bolt Driver Trust Strategy: {}", (Object)ogmConfig.getTrustStrategy());
                    throw iae;
                }
                if (ogmConfig.getTrustCertFile() == null) {
                    throw new IllegalArgumentException("Missing configuration value for trust.certificate.file");
                }
                File knownHostsFile = new File(new URI(ogmConfig.getTrustCertFile()));
                if (trustStrategy == Config.TrustStrategy.Strategy.TRUST_ON_FIRST_USE) {
                    configBuilder.withTrustStrategy(Config.TrustStrategy.trustOnFirstUse((File)knownHostsFile));
                }
                if (trustStrategy == Config.TrustStrategy.Strategy.TRUST_SIGNED_CERTIFICATES) {
                    configBuilder.withTrustStrategy(Config.TrustStrategy.trustSignedBy((File)knownHostsFile));
                }
            }
            if (ogmConfig.getConnectionLivenessCheckTimeout() != null) {
                configBuilder.withConnectionLivenessCheckTimeout((long)ogmConfig.getConnectionLivenessCheckTimeout().intValue(), TimeUnit.MILLISECONDS);
            }
            this.getBoltLogging().ifPresent(arg_0 -> ((Config.ConfigBuilder)configBuilder).withLogging(arg_0));
            return configBuilder.toConfig();
        }
        catch (Exception e) {
            throw new ConnectionException("Unable to build driver configuration", (Throwable)e);
        }
    }
}

