/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.request;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.DatabaseException;
import org.neo4j.driver.v1.exceptions.TransientException;
import org.neo4j.ogm.config.ObjectMapperFactory;
import org.neo4j.ogm.drivers.bolt.response.GraphModelResponse;
import org.neo4j.ogm.drivers.bolt.response.GraphRowModelResponse;
import org.neo4j.ogm.drivers.bolt.response.RestModelResponse;
import org.neo4j.ogm.drivers.bolt.response.RowModelResponse;
import org.neo4j.ogm.drivers.bolt.transaction.BoltTransaction;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.GraphRowListModel;
import org.neo4j.ogm.model.RestModel;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.request.DefaultRequest;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.request.GraphRowListModelRequest;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.request.RestModelRequest;
import org.neo4j.ogm.request.RowModelRequest;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.response.EmptyResponse;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltRequest
implements Request {
    private final TransactionManager transactionManager;
    private static final ObjectMapper mapper = ObjectMapperFactory.objectMapper();
    private final Logger LOGGER = LoggerFactory.getLogger(BoltRequest.class);
    private TypeReference<HashMap<String, Object>> MAP_TYPE_REF = new TypeReference<HashMap<String, Object>>(){};

    public BoltRequest(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public Response<GraphModel> execute(GraphModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        return new GraphModelResponse(this.executeRequest((Statement)request), this.transactionManager);
    }

    public Response<RowModel> execute(RowModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        return new RowModelResponse(this.executeRequest((Statement)request), this.transactionManager);
    }

    public Response<RowModel> execute(DefaultRequest query) {
        final ArrayList<RowModel> rowmodels = new ArrayList<RowModel>();
        String[] columns = null;
        for (Statement statement : query.getStatements()) {
            StatementResult result = this.executeRequest(statement);
            if (columns == null) {
                List columnSet = result.keys();
                columns = columnSet.toArray(new String[columnSet.size()]);
            }
            RowModelResponse rowModelResponse = new RowModelResponse(result, this.transactionManager);
            Throwable throwable = null;
            try {
                RowModel model;
                while ((model = (RowModel)rowModelResponse.next()) != null) {
                    rowmodels.add(model);
                }
                result.consume();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rowModelResponse == null) continue;
                if (throwable != null) {
                    try {
                        rowModelResponse.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rowModelResponse.close();
            }
        }
        final String[] finalColumns = columns;
        return new Response<RowModel>(){
            int currentRow = 0;

            public RowModel next() {
                if (this.currentRow < rowmodels.size()) {
                    return (RowModel)rowmodels.get(this.currentRow++);
                }
                return null;
            }

            public void close() {
            }

            public String[] columns() {
                return finalColumns;
            }
        };
    }

    public Response<GraphRowListModel> execute(GraphRowListModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        return new GraphRowModelResponse(this.executeRequest((Statement)request), this.transactionManager);
    }

    public Response<RestModel> execute(RestModelRequest request) {
        if (request.getStatement().length() == 0) {
            return new EmptyResponse();
        }
        return new RestModelResponse(this.executeRequest((Statement)request), this.transactionManager);
    }

    private StatementResult executeRequest(Statement request) {
        try {
            Map parameterMap = (Map)mapper.convertValue((Object)request.getParameters(), this.MAP_TYPE_REF);
            this.LOGGER.info("Request: {} with params {}", (Object)request.getStatement(), (Object)parameterMap);
            BoltTransaction tx = (BoltTransaction)this.transactionManager.getCurrentTransaction();
            return tx.nativeBoltTransaction().run(request.getStatement(), parameterMap);
        }
        catch (ClientException | DatabaseException | TransientException ce) {
            throw new CypherException("Error executing Cypher", ce, ce.code(), ce.getMessage());
        }
    }
}

