/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.transaction;

import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.exception.TransactionException;
import org.neo4j.ogm.transaction.AbstractTransaction;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltTransaction
extends AbstractTransaction {
    private static final String NEO_CLIENT_ERROR_SECURITY = "Neo.ClientError.Security";
    private final Transaction nativeTransaction;
    private final Session nativeSession;
    private final Logger LOGGER = LoggerFactory.getLogger(BoltTransaction.class);

    public BoltTransaction(TransactionManager transactionManager, Session session, Transaction.Type type) {
        super(transactionManager);
        this.nativeSession = session;
        this.nativeTransaction = this.newOrExistingNativeTransaction(transactionManager.getCurrentTransaction());
        this.type = type;
    }

    private Transaction newOrExistingNativeTransaction(org.neo4j.ogm.transaction.Transaction currentOGMTransaction) {
        Transaction newOrExistingNativeTransaction;
        if (currentOGMTransaction != null) {
            this.LOGGER.debug("Using current transaction: {}", (Object)currentOGMTransaction);
            newOrExistingNativeTransaction = ((BoltTransaction)currentOGMTransaction).nativeBoltTransaction();
        } else {
            this.LOGGER.debug("No current transaction, starting a new one");
            newOrExistingNativeTransaction = this.nativeSession.beginTransaction();
        }
        this.LOGGER.debug("Native transaction: {}", (Object)newOrExistingNativeTransaction);
        return newOrExistingNativeTransaction;
    }

    public void rollback() {
        try {
            if (this.transactionManager.canRollback()) {
                this.LOGGER.debug("Rolling back native transaction: {}", (Object)this.nativeTransaction);
                if (this.nativeTransaction.isOpen()) {
                    this.nativeTransaction.failure();
                    this.nativeTransaction.close();
                } else {
                    this.LOGGER.warn("Transaction is already closed");
                }
                this.closeNativeSessionIfPossible();
            }
        }
        catch (Exception e) {
            this.closeNativeSessionIfPossible();
            throw new TransactionException(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            super.rollback();
        }
    }

    public void commit() {
        block9: {
            boolean canCommit = this.transactionManager.canCommit();
            try {
                if (!canCommit) break block9;
                this.LOGGER.debug("Committing native transaction: {}", (Object)this.nativeTransaction);
                if (this.nativeTransaction.isOpen()) {
                    this.nativeTransaction.success();
                    this.nativeTransaction.close();
                    this.nativeSession.close();
                    break block9;
                }
                throw new IllegalStateException("Transaction is already closed");
            }
            catch (ClientException ce) {
                this.closeNativeSessionIfPossible();
                if (ce.code().startsWith(NEO_CLIENT_ERROR_SECURITY)) {
                    throw new ConnectionException("Security Error: " + ce.code() + ", " + ce.getMessage(), (Throwable)ce);
                }
                throw new CypherException(ce.code(), ce.getMessage(), (Throwable)ce);
            }
            catch (Exception e) {
                this.closeNativeSessionIfPossible();
                throw new TransactionException(e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                super.commit();
                if (canCommit) {
                    this.transactionManager.bookmark(this.nativeSession.lastBookmark());
                }
            }
        }
    }

    public Transaction nativeBoltTransaction() {
        return this.nativeTransaction;
    }

    private void closeNativeSessionIfPossible() {
        if (this.nativeSession.isOpen()) {
            this.nativeSession.close();
        }
    }
}

