/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.driver;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.Scheme;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.config.Credentials;
import org.neo4j.ogm.config.DatabaseSelectionProvider;
import org.neo4j.ogm.config.UserSelectionProvider;
import org.neo4j.ogm.config.UsernamePasswordCredentials;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.driver.ExceptionTranslator;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriverExceptionTranslator;
import org.neo4j.ogm.drivers.bolt.driver.BoltEntityAdapter;
import org.neo4j.ogm.drivers.bolt.request.BoltRequest;
import org.neo4j.ogm.drivers.bolt.transaction.BoltTransaction;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltDriver
extends AbstractConfigurableDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoltDriver.class);
    public static final String CONFIG_PARAMETER_BOLT_LOGGING = "Bolt_Logging";
    private static final Method WITH_IMPERSONATED_USER = BoltDriver.findWithImpersonatedUser();
    private final ExceptionTranslator exceptionTranslator = new BoltDriverExceptionTranslator();
    private volatile Driver boltDriver;
    private Credentials credentials;
    private Config driverConfig;
    private String database = null;
    private DatabaseSelectionProvider databaseSelectionProvider;
    private UserSelectionProvider userSelectionProvider;

    private static Method findWithImpersonatedUser() {
        try {
            return SessionConfig.Builder.class.getMethod("withImpersonatedUser", String.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public BoltDriver() {
    }

    public BoltDriver(Driver boltDriver) {
        this(boltDriver, Collections::emptyMap);
    }

    public BoltDriver(Driver boltDriver, Supplier<Map<String, Object>> customPropertiesSupplier) {
        super(customPropertiesSupplier);
        this.boltDriver = Objects.requireNonNull(boltDriver);
    }

    public void configure(Configuration newConfiguration) {
        this.close();
        super.configure(newConfiguration);
        this.driverConfig = this.buildDriverConfig();
        this.credentials = this.configuration.getCredentials();
        this.configureSessionConfig(newConfiguration);
        if (this.configuration.getVerifyConnection().booleanValue()) {
            this.checkDriverInitialized();
        }
    }

    public void configureSessionConfig(Configuration newConfiguration) {
        this.configuration = newConfiguration;
        this.database = this.configuration.getDatabase();
        this.databaseSelectionProvider = this.configuration.getDatabaseSelectionProvider();
        this.userSelectionProvider = this.configuration.getUserSelectionProvider();
    }

    protected String getTypeSystemName() {
        return "org.neo4j.ogm.drivers.bolt.types.BoltNativeTypes";
    }

    public Function<TransactionManager, BiFunction<Transaction.Type, Iterable<String>, Transaction>> getTransactionFactorySupplier() {
        return transactionManager -> (type, bookmarks) -> {
            this.checkDriverInitialized();
            Session session = this.newSession((Transaction.Type)type, (Iterable<String>)bookmarks);
            return new BoltTransaction((TransactionManager)transactionManager, session, (Transaction.Type)type);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDriverInitialized() {
        Driver driver = this.boltDriver;
        if (driver == null) {
            BoltDriver boltDriver = this;
            synchronized (boltDriver) {
                driver = this.boltDriver;
                if (driver == null) {
                    this.initializeDriver();
                }
            }
        }
    }

    static boolean isSimpleScheme(String scheme) {
        String lowerCaseScheme = scheme.toLowerCase(Locale.ENGLISH);
        try {
            Scheme.validateScheme((String)lowerCaseScheme);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("'%s' is not a supported scheme.", scheme));
        }
        return lowerCaseScheme.equals("bolt") || lowerCaseScheme.equals("neo4j");
    }

    private void initializeDriver() {
        String serviceUnavailableMessage = "Could not create driver instance";
        try (Driver driver = null;){
            if (this.credentials != null) {
                UsernamePasswordCredentials usernameAndPassword = (UsernamePasswordCredentials)this.credentials;
                AuthToken authToken = AuthTokens.basic((String)usernameAndPassword.getUsername(), (String)usernameAndPassword.getPassword());
                driver = this.createDriver(authToken);
            } else {
                LOGGER.debug("Bolt Driver credentials not supplied");
                driver = this.createDriver(AuthTokens.none());
            }
            driver.verifyConnectivity();
            this.boltDriver = driver;
            driver = null;
        }
    }

    private Driver createDriver(AuthToken authToken) {
        if (this.isRoutingConfig()) {
            return GraphDatabase.routingDriver(this.getMergedURIs(), (AuthToken)authToken, (Config)this.driverConfig);
        }
        return GraphDatabase.driver((URI)this.getSingleURI(), (AuthToken)authToken, (Config)this.driverConfig);
    }

    private boolean isRoutingConfig() {
        String[] uris = this.configuration.getURIS();
        String uri = this.configuration.getURI();
        return uris != null && (uri == null && uris.length > 1 || uri != null && uris.length >= 1);
    }

    private List<URI> getMergedURIs() {
        ArrayList<URI> mergedUris = new ArrayList<URI>();
        String uri = this.configuration.getURI();
        String[] uris = this.configuration.getURIS();
        if (uri != null) {
            mergedUris.add(BoltDriver.fixProtocolIfNecessary(URI.create(uri)));
        }
        if (uris != null) {
            for (String routingUri : uris) {
                mergedUris.add(BoltDriver.fixProtocolIfNecessary(URI.create(routingUri)));
            }
        }
        return mergedUris;
    }

    private URI getSingleURI() {
        String singleUri;
        if (this.configuration.getURI() != null) {
            singleUri = this.configuration.getURI();
        } else {
            String[] uris = this.configuration.getURIS();
            if (uris == null || this.configuration.getURIS().length == 0) {
                throw new IllegalArgumentException("You must provide either an URI or at least one URI in the URIS parameter.");
            }
            singleUri = this.configuration.getURIS()[0];
        }
        return BoltDriver.fixProtocolIfNecessary(URI.create(singleUri));
    }

    private static URI fixProtocolIfNecessary(URI uri) {
        if ("bolt+routing".equals(uri.getScheme().toLowerCase(Locale.ENGLISH))) {
            return URI.create(uri.toString().replaceAll("^bolt\\+routing", "neo4j"));
        }
        return uri;
    }

    public synchronized void close() {
        if (this.boltDriver != null) {
            try {
                LOGGER.info("Shutting down Bolt driver {} ", (Object)this.boltDriver);
                this.boltDriver.close();
                this.boltDriver = null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    public Request request(Transaction transaction) {
        return new BoltRequest(transaction, this.parameterConversion, new BoltEntityAdapter(this.typeSystem), this.getCypherModification());
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz == Driver.class) {
            return (T)this.boltDriver;
        }
        return (T)super.unwrap(clazz);
    }

    private Session newSession(Transaction.Type type, Iterable<String> bookmarks) {
        Session boltSession;
        try {
            AccessMode accessMode = type.equals((Object)Transaction.Type.READ_ONLY) ? AccessMode.READ : AccessMode.WRITE;
            SessionConfig.Builder sessionConfigBuilder = SessionConfig.builder().withDefaultAccessMode(accessMode).withBookmarks(BoltDriver.bookmarksFromStrings(bookmarks));
            if (this.database != null) {
                sessionConfigBuilder = sessionConfigBuilder.withDatabase(this.database);
            }
            if (this.databaseSelectionProvider != null && this.databaseSelectionProvider != DatabaseSelectionProvider.getDefaultSelectionProvider()) {
                sessionConfigBuilder = sessionConfigBuilder.withDatabase(this.databaseSelectionProvider.getDatabaseSelection().getValue());
            }
            if (this.userSelectionProvider != null && this.userSelectionProvider != UserSelectionProvider.getDefaultSelectionProvider()) {
                BoltDriver.setWithImpersonatedUser(sessionConfigBuilder, this.userSelectionProvider.getUserSelection().getValue());
            }
            boltSession = this.boltDriver.session(sessionConfigBuilder.build());
        }
        catch (ClientException ce) {
            throw new ConnectionException("Error connecting to graph database using Bolt: " + ce.code() + ", " + ce.getMessage(), (Throwable)ce);
        }
        catch (Exception e) {
            throw new ConnectionException("Error connecting to graph database using Bolt", (Throwable)e);
        }
        return boltSession;
    }

    static void setWithImpersonatedUser(SessionConfig.Builder builder, String user) {
        if (WITH_IMPERSONATED_USER == null) {
            return;
        }
        try {
            WITH_IMPERSONATED_USER.invoke((Object)builder, user);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Could not impersonate a user on the driver level", e);
        }
    }

    private Optional<Logging> getBoltLogging() {
        Object possibleLogging = ((Map)this.customPropertiesSupplier.get()).get(CONFIG_PARAMETER_BOLT_LOGGING);
        if (possibleLogging != null && !(possibleLogging instanceof Logging)) {
            LOGGER.warn("Invalid object of type {} for {}, not changing log.", possibleLogging.getClass(), (Object)CONFIG_PARAMETER_BOLT_LOGGING);
            possibleLogging = null;
        }
        LOGGER.debug("Using {} for bolt logging.", possibleLogging == null ? "default" : possibleLogging.getClass());
        return Optional.ofNullable((Logging)possibleLogging);
    }

    private Config buildDriverConfig() {
        boolean shouldApplyEncryptionAndTrustSettings;
        if (this.isRoutingConfig()) {
            shouldApplyEncryptionAndTrustSettings = true;
        } else {
            URI singleUri = null;
            try {
                singleUri = this.getSingleURI();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            shouldApplyEncryptionAndTrustSettings = singleUri == null || BoltDriver.isSimpleScheme(singleUri.getScheme());
        }
        try {
            Config.ConfigBuilder configBuilder = Config.builder();
            configBuilder.withMaxConnectionPoolSize(this.configuration.getConnectionPoolSize());
            if (shouldApplyEncryptionAndTrustSettings) {
                this.applyEncryptionAndTrustSettings(configBuilder);
            }
            if (this.configuration.getConnectionLivenessCheckTimeout() != null) {
                configBuilder.withConnectionLivenessCheckTimeout((long)this.configuration.getConnectionLivenessCheckTimeout().intValue(), TimeUnit.MILLISECONDS);
            }
            this.getBoltLogging().ifPresent(arg_0 -> ((Config.ConfigBuilder)configBuilder).withLogging(arg_0));
            return configBuilder.build();
        }
        catch (Exception e) {
            throw new ConnectionException("Unable to build driver configuration", (Throwable)e);
        }
    }

    private void applyEncryptionAndTrustSettings(Config.ConfigBuilder configBuilder) {
        if (this.configuration.getEncryptionLevel() != null && "REQUIRED".equals(this.configuration.getEncryptionLevel().toUpperCase(Locale.ENGLISH).trim())) {
            configBuilder.withEncryption();
        } else {
            configBuilder.withoutEncryption();
        }
        if (this.configuration.getTrustStrategy() != null) {
            Config.TrustStrategy.Strategy trustStrategy;
            String configuredTrustStrategy = this.configuration.getTrustStrategy().toUpperCase(Locale.ENGLISH).trim();
            if (Arrays.asList("TRUST_ON_FIRST_USE", "TRUST_SIGNED_CERTIFICATES").contains(configuredTrustStrategy)) {
                String validNames = Arrays.stream(Config.TrustStrategy.Strategy.values()).map(Enum::name).collect(Collectors.joining(", "));
                throw new IllegalArgumentException("Truststrategy " + configuredTrustStrategy + " is no longer supported, please choose one of " + validNames);
            }
            try {
                trustStrategy = Config.TrustStrategy.Strategy.valueOf((String)configuredTrustStrategy);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.debug("Invalid configuration for the Bolt Driver Trust Strategy: {}", (Object)this.configuration.getTrustStrategy());
                throw iae;
            }
            switch (trustStrategy) {
                case TRUST_ALL_CERTIFICATES: {
                    configBuilder.withTrustStrategy(Config.TrustStrategy.trustAllCertificates());
                    break;
                }
                case TRUST_SYSTEM_CA_SIGNED_CERTIFICATES: {
                    configBuilder.withTrustStrategy(Config.TrustStrategy.trustSystemCertificates());
                    break;
                }
                case TRUST_CUSTOM_CA_SIGNED_CERTIFICATES: {
                    if (this.configuration.getTrustCertFile() == null) {
                        throw new IllegalArgumentException("Configured trust strategy requires a certificate file.");
                    }
                    configBuilder.withTrustStrategy(Config.TrustStrategy.trustCustomCertificateSignedBy((File[])new File[]{new File(URI.create(this.configuration.getTrustCertFile()))}));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown strategy." + trustStrategy);
                }
            }
        }
    }

    static List<Bookmark> bookmarksFromStrings(Iterable<String> bookmarks) {
        return StreamSupport.stream(bookmarks.spliterator(), false).map(b -> Arrays.stream(b.split("/_BS_/")).collect(Collectors.collectingAndThen(Collectors.toSet(), Bookmark::from))).collect(Collectors.toList());
    }
}

