/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.compiler.emitters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.compiler.CypherEmitter;
import org.neo4j.ogm.model.Edge;

public class DeletedRelationshipEmitter
implements CypherEmitter {
    private Set<Edge> deletedEdges;

    public DeletedRelationshipEmitter(Set<Edge> deletedEdges) {
        this.deletedEdges = deletedEdges;
    }

    public void emit(StringBuilder queryBuilder, Map<String, Object> parameters) {
        if (this.deletedEdges != null && this.deletedEdges.size() > 0) {
            Edge firstEdge = this.deletedEdges.iterator().next();
            queryBuilder.append("UNWIND {rows} as row ").append("MATCH (startNode) WHERE ID(startNode) = row.startNodeId ").append("MATCH (endNode) WHERE ID(endNode) = row.endNodeId ").append("MATCH (startNode)-[rel:`").append(firstEdge.getType()).append("`]->(endNode) ").append("DELETE rel");
            ArrayList rows = new ArrayList();
            for (Edge edge : this.deletedEdges) {
                HashMap<String, Long> rowMap = new HashMap<String, Long>();
                rowMap.put("startNodeId", edge.getStartNode());
                rowMap.put("endNodeId", edge.getEndNode());
                rows.add(rowMap);
            }
            parameters.put("rows", rows);
        }
    }
}

