/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.compiler.CompileContext;
import org.neo4j.ogm.compiler.Compiler;
import org.neo4j.ogm.compiler.CypherContext;
import org.neo4j.ogm.compiler.NodeBuilder;
import org.neo4j.ogm.compiler.RelationshipBuilder;
import org.neo4j.ogm.compiler.builders.DefaultNodeBuilder;
import org.neo4j.ogm.compiler.builders.DefaultRelationshipBuilder;
import org.neo4j.ogm.compiler.emitters.DeletedRelationshipEmitter;
import org.neo4j.ogm.compiler.emitters.DeletedRelationshipEntityEmitter;
import org.neo4j.ogm.compiler.emitters.ExistingNodeEmitter;
import org.neo4j.ogm.compiler.emitters.ExistingRelationshipEmitter;
import org.neo4j.ogm.compiler.emitters.NewNodeEmitter;
import org.neo4j.ogm.compiler.emitters.NewRelationshipEmitter;
import org.neo4j.ogm.exception.UnknownStatementTypeException;
import org.neo4j.ogm.model.Edge;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;
import org.neo4j.ogm.response.model.RelationshipModel;

public class MultiStatementCypherCompiler
implements Compiler {
    private final CompileContext context = new CypherContext(this);
    private List<NodeBuilder> newNodeBuilders = new ArrayList<NodeBuilder>();
    private List<RelationshipBuilder> newRelationshipBuilders = new ArrayList<RelationshipBuilder>();
    private List<NodeBuilder> existingNodeBuilders = new ArrayList<NodeBuilder>();
    private List<RelationshipBuilder> existingRelationshipBuilders = new ArrayList<RelationshipBuilder>();
    private List<RelationshipBuilder> deletedRelationshipBuilders = new ArrayList<RelationshipBuilder>();
    private List<RelationshipBuilder> deletedRelationshipEntityBuilders = new ArrayList<RelationshipBuilder>();
    private StatementFactory statementFactory;

    public NodeBuilder newNode(Long id) {
        DefaultNodeBuilder nodeBuilder = new DefaultNodeBuilder(id);
        this.newNodeBuilders.add(nodeBuilder);
        return nodeBuilder;
    }

    public RelationshipBuilder newRelationship(String type, boolean bidirectional) {
        DefaultRelationshipBuilder relationshipBuilder = new DefaultRelationshipBuilder(type, bidirectional);
        this.newRelationshipBuilders.add(relationshipBuilder);
        return relationshipBuilder;
    }

    public RelationshipBuilder newRelationship(String type) {
        return this.newRelationship(type, false);
    }

    public NodeBuilder existingNode(Long existingNodeId) {
        DefaultNodeBuilder nodeBuilder = new DefaultNodeBuilder(existingNodeId);
        this.existingNodeBuilders.add(nodeBuilder);
        return nodeBuilder;
    }

    public RelationshipBuilder existingRelationship(Long existingRelationshipId, String type) {
        DefaultRelationshipBuilder relationshipBuilder = new DefaultRelationshipBuilder(type, existingRelationshipId);
        this.existingRelationshipBuilders.add(relationshipBuilder);
        return relationshipBuilder;
    }

    public void unrelate(Long startNode, String relationshipType, Long endNode, Long relId) {
        DefaultRelationshipBuilder relationshipBuilder = new DefaultRelationshipBuilder(relationshipType, relId);
        relationshipBuilder.relate(startNode, endNode);
        if (!this.unmap(relationshipBuilder)) {
            if (relId != null) {
                this.deletedRelationshipEntityBuilders.add(relationshipBuilder);
            } else {
                this.deletedRelationshipBuilders.add(relationshipBuilder);
            }
        }
    }

    public void unmap(NodeBuilder nodeBuilder) {
        this.existingNodeBuilders.remove(nodeBuilder);
    }

    public List<Statement> createNodesStatements() {
        this.assertStatementFactoryExists();
        Map<String, Set<Node>> newNodesByLabels = this.groupNodesByLabel(this.newNodeBuilders);
        ArrayList<Statement> statements = new ArrayList<Statement>(newNodesByLabels.size());
        for (Set<Node> nodeModels : newNodesByLabels.values()) {
            NewNodeEmitter newNodeEmitter = new NewNodeEmitter(nodeModels);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            StringBuilder query = new StringBuilder();
            newNodeEmitter.emit(query, parameters);
            statements.add(this.statementFactory.statement(query.toString(), parameters));
        }
        return statements;
    }

    public List<Statement> createRelationshipsStatements() {
        this.assertStatementFactoryExists();
        HashMap relsByTypeAndProps = new HashMap();
        for (RelationshipBuilder relationshipBuilder : this.newRelationshipBuilders) {
            if (relationshipBuilder.edge().getStartNode() == null || relationshipBuilder.edge().getEndNode() == null) continue;
            if (!relsByTypeAndProps.containsKey(relationshipBuilder.type())) {
                relsByTypeAndProps.put(relationshipBuilder.type(), new HashMap());
            }
            RelationshipModel edge = (RelationshipModel)relationshipBuilder.edge();
            HashSet<String> nonNullPropertyKeys = new HashSet<String>();
            Iterator propertyIterator = edge.getPropertyList().iterator();
            while (propertyIterator.hasNext()) {
                Property property = (Property)propertyIterator.next();
                if (property.getValue() == null) {
                    propertyIterator.remove();
                    continue;
                }
                nonNullPropertyKeys.add((String)property.getKey());
            }
            if (!((Map)relsByTypeAndProps.get(relationshipBuilder.type())).containsKey(nonNullPropertyKeys)) {
                ((Map)relsByTypeAndProps.get(relationshipBuilder.type())).put(nonNullPropertyKeys, new HashSet());
            }
            edge.setStartNode(this.context.getId(edge.getStartNode()));
            edge.setEndNode(this.context.getId(edge.getEndNode()));
            ((Set)((Map)relsByTypeAndProps.get(relationshipBuilder.type())).get(nonNullPropertyKeys)).add(edge);
        }
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (Map edgesByProperties : relsByTypeAndProps.values()) {
            for (Set edges : edgesByProperties.values()) {
                NewRelationshipEmitter newRelationshipEmitter = new NewRelationshipEmitter(edges);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                StringBuilder query = new StringBuilder();
                newRelationshipEmitter.emit(query, parameters);
                statements.add(this.statementFactory.statement(query.toString(), parameters));
            }
        }
        return statements;
    }

    public List<Statement> updateNodesStatements() {
        this.assertStatementFactoryExists();
        Map<String, Set<Node>> existingNodesByLabels = this.groupNodesByLabel(this.existingNodeBuilders);
        ArrayList<Statement> statements = new ArrayList<Statement>(existingNodesByLabels.size());
        for (Set<Node> nodeModels : existingNodesByLabels.values()) {
            ExistingNodeEmitter existingNodeEmitter = new ExistingNodeEmitter(nodeModels);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            StringBuilder query = new StringBuilder();
            existingNodeEmitter.emit(query, parameters);
            statements.add(this.statementFactory.statement(query.toString(), parameters));
        }
        return statements;
    }

    public List<Statement> updateRelationshipStatements() {
        this.assertStatementFactoryExists();
        HashSet<Edge> relationships = new HashSet<Edge>(this.existingRelationshipBuilders.size());
        ArrayList<Statement> statements = new ArrayList<Statement>(this.existingRelationshipBuilders.size());
        if (this.existingRelationshipBuilders.size() > 0) {
            for (RelationshipBuilder relBuilder : this.existingRelationshipBuilders) {
                relationships.add(relBuilder.edge());
            }
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            StringBuilder query = new StringBuilder();
            ExistingRelationshipEmitter existingRelationshipEmitter = new ExistingRelationshipEmitter(relationships);
            existingRelationshipEmitter.emit(query, parameters);
            statements.add(this.statementFactory.statement(query.toString(), parameters));
        }
        return statements;
    }

    public List<Statement> deleteRelationshipStatements() {
        this.assertStatementFactoryExists();
        Map<String, Set<Edge>> deletedRelsByType = this.groupRelationshipsByType(this.deletedRelationshipBuilders);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (Set<Edge> edges : deletedRelsByType.values()) {
            DeletedRelationshipEmitter deletedRelationshipEmitter = new DeletedRelationshipEmitter(edges);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            StringBuilder query = new StringBuilder();
            deletedRelationshipEmitter.emit(query, parameters);
            statements.add(this.statementFactory.statement(query.toString(), parameters));
        }
        return statements;
    }

    public List<Statement> deleteRelationshipEntityStatements() {
        this.assertStatementFactoryExists();
        Map<String, Set<Edge>> deletedRelsByType = this.groupRelationshipsByType(this.deletedRelationshipEntityBuilders);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (Set<Edge> edges : deletedRelsByType.values()) {
            DeletedRelationshipEntityEmitter deletedRelationshipEmitter = new DeletedRelationshipEntityEmitter(edges);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            StringBuilder query = new StringBuilder();
            deletedRelationshipEmitter.emit(query, parameters);
            statements.add(this.statementFactory.statement(query.toString(), parameters));
        }
        return statements;
    }

    public List<Statement> getAllStatements() {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.addAll(this.createNodesStatements());
        statements.addAll(this.createRelationshipsStatements());
        statements.addAll(this.updateNodesStatements());
        statements.addAll(this.updateRelationshipStatements());
        statements.addAll(this.deleteRelationshipStatements());
        statements.addAll(this.deleteRelationshipEntityStatements());
        return statements;
    }

    public CompileContext context() {
        return this.context;
    }

    public boolean hasStatementsDependentOnNewNodes() {
        for (RelationshipBuilder builder : this.newRelationshipBuilders) {
            Edge edge = builder.edge();
            if ((edge.getStartNode() == null || edge.getStartNode() >= 0L) && (edge.getEndNode() == null || edge.getEndNode() >= 0L)) continue;
            return true;
        }
        return false;
    }

    public void useStatementFactory(StatementFactory statementFactory) {
        this.statementFactory = statementFactory;
    }

    private boolean unmap(RelationshipBuilder relationshipBuilder) {
        boolean unmapped = false;
        Iterator<RelationshipBuilder> relIterator = this.newRelationshipBuilders.iterator();
        while (relIterator.hasNext()) {
            RelationshipBuilder newRelBuilder = relIterator.next();
            if (relationshipBuilder.reference() >= 0L) {
                if (!relationshipBuilder.reference().equals(newRelBuilder.reference())) continue;
                relIterator.remove();
                unmapped = true;
                break;
            }
            if (!relationshipBuilder.type().equals(newRelBuilder.type()) || !relationshipBuilder.edge().getStartNode().equals(newRelBuilder.edge().getStartNode()) || !relationshipBuilder.edge().getEndNode().equals(newRelBuilder.edge().getEndNode())) continue;
            relIterator.remove();
            unmapped = true;
            break;
        }
        return unmapped;
    }

    private void assertStatementFactoryExists() {
        if (this.statementFactory == null) {
            throw new UnknownStatementTypeException("Unknown statement type- statementFactory must be specified!");
        }
    }

    private Map<String, Set<Node>> groupNodesByLabel(List<NodeBuilder> nodeBuilders) {
        HashMap<String, Set<Node>> nodesByLabels = new HashMap<String, Set<Node>>();
        for (NodeBuilder nodeBuilder : nodeBuilders) {
            String joinedLabels = this.join(nodeBuilder.addedLabels());
            if (!nodesByLabels.containsKey(joinedLabels)) {
                nodesByLabels.put(joinedLabels, new HashSet());
            }
            ((Set)nodesByLabels.get(joinedLabels)).add(nodeBuilder.node());
        }
        return nodesByLabels;
    }

    private Map<String, Set<Edge>> groupRelationshipsByType(List<RelationshipBuilder> relationshipBuilders) {
        HashMap<String, Set<Edge>> relsByType = new HashMap<String, Set<Edge>>();
        for (RelationshipBuilder relationshipBuilder : relationshipBuilders) {
            if (!relsByType.containsKey(relationshipBuilder.type())) {
                relsByType.put(relationshipBuilder.type(), new HashSet());
            }
            RelationshipModel edge = (RelationshipModel)relationshipBuilder.edge();
            edge.setStartNode(this.context.getId(edge.getStartNode()));
            edge.setEndNode(this.context.getId(edge.getEndNode()));
            ((Set)relsByType.get(relationshipBuilder.type())).add(edge);
            ((Set)relsByType.get(relationshipBuilder.type())).add(edge);
        }
        return relsByType;
    }

    private String join(String[] parts) {
        StringBuilder str = new StringBuilder();
        for (String part : parts) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(part);
        }
        return str.toString();
    }
}

