/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.compiler.emitters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.compiler.CypherEmitter;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;

public class ExistingNodeEmitter
implements CypherEmitter {
    private Set<Node> existingNodes;

    public ExistingNodeEmitter(Set<Node> existingNodes) {
        this.existingNodes = existingNodes;
    }

    public void emit(StringBuilder queryBuilder, Map<String, Object> parameters) {
        if (this.existingNodes != null && this.existingNodes.size() > 0) {
            Node firstNode = this.existingNodes.iterator().next();
            queryBuilder.append("UNWIND {rows} as row ").append("MATCH (n) WHERE ID(n)=row.nodeId ");
            String[] removedLabels = firstNode.getRemovedLabels();
            if (removedLabels != null && removedLabels.length > 0) {
                for (String label : removedLabels) {
                    queryBuilder.append(String.format(" REMOVE n:`%s` ", label));
                }
            }
            queryBuilder.append("SET n");
            for (String label : firstNode.getLabels()) {
                queryBuilder.append(":`").append(label).append("`");
            }
            queryBuilder.append(" SET n += row.props RETURN row.nodeId as ref, ID(n) as id, row.type as type");
            ArrayList rows = new ArrayList();
            for (Node node : this.existingNodes) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                rowMap.put("nodeId", node.getId());
                rowMap.put("type", "node");
                HashMap<String, Object> props = new HashMap<String, Object>();
                for (Property property : node.getPropertyList()) {
                    props.put((String)property.getKey(), property.getValue());
                }
                rowMap.put("props", props);
                rows.add(rowMap);
            }
            parameters.put("rows", rows);
        }
    }
}

