/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.extension;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.configuration.Configuration;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.drivers.embedded.driver.EmbeddedDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.plugins.PluginLifecycle;

public abstract class OgmPluginInitializer
implements PluginLifecycle {
    protected final String packages;
    protected SessionFactory sessionFactory;

    public OgmPluginInitializer(String packages) {
        this.packages = packages;
    }

    public Collection<Injectable<?>> start(GraphDatabaseService graphDatabaseService, Configuration config) {
        EmbeddedDriver embeddedDriver = new EmbeddedDriver(graphDatabaseService);
        this.sessionFactory = this.createSessionFactory(embeddedDriver);
        return Arrays.asList(new OgmInjectable<SessionFactory>(this.sessionFactory, SessionFactory.class));
    }

    protected SessionFactory createSessionFactory(EmbeddedDriver embeddedDriver) {
        return new SessionFactory((Driver)embeddedDriver, new String[]{this.packages});
    }

    public void stop() {
    }

    public static class OgmInjectable<T>
    implements Injectable<T> {
        private final Class<T> injectableClass;
        private final T injectable;

        public OgmInjectable(T injectable, Class<T> injectableClass) {
            this.injectable = injectable;
            this.injectableClass = injectableClass;
        }

        public T getValue() {
            return this.injectable;
        }

        public Class<T> getType() {
            return this.injectableClass;
        }
    }
}

