/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.driver;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.drivers.embedded.driver.EmbeddedEntityAdapter;
import org.neo4j.ogm.drivers.embedded.request.EmbeddedRequest;
import org.neo4j.ogm.drivers.embedded.transaction.EmbeddedTransaction;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.support.FileUtils;
import org.neo4j.ogm.support.ResourceUtils;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedDriver
extends AbstractConfigurableDriver {
    private static final int TIMEOUT = 60000;
    private final Logger logger = LoggerFactory.getLogger(EmbeddedDriver.class);
    private GraphDatabaseService graphDatabaseService;

    public EmbeddedDriver() {
    }

    public EmbeddedDriver(GraphDatabaseService graphDatabaseService, Configuration configuration) {
        this(graphDatabaseService, configuration, Collections::emptyMap);
    }

    public EmbeddedDriver(GraphDatabaseService graphDatabaseService, Configuration configuration, Supplier<Map<String, Object>> customPropertiesSupplier) {
        super(customPropertiesSupplier);
        super.configure(configuration);
        this.graphDatabaseService = Objects.requireNonNull(graphDatabaseService);
        boolean available = this.graphDatabaseService.isAvailable(60000L);
        if (!available) {
            throw new IllegalArgumentException("Provided GraphDatabaseService is not in usable state");
        }
    }

    public synchronized void configure(Configuration newConfiguration) {
        super.configure(newConfiguration);
        try {
            String fileStoreUri = newConfiguration.getURI();
            if (fileStoreUri == null) {
                fileStoreUri = this.createTemporaryFileStore();
            } else {
                this.createPermanentFileStore(fileStoreUri);
            }
            File file = new File(new URI(fileStoreUri));
            if (!file.exists()) {
                throw new RuntimeException("Could not create/open filestore: " + fileStoreUri);
            }
            GraphDatabaseBuilder graphDatabaseBuilder = EmbeddedDriver.getGraphDatabaseFactory(newConfiguration).newEmbeddedDatabaseBuilder(file);
            String neo4jConfLocation = newConfiguration.getNeo4jConfLocation();
            if (neo4jConfLocation != null) {
                URL neo4ConfUrl = ResourceUtils.getResourceUrl((String)neo4jConfLocation);
                graphDatabaseBuilder = graphDatabaseBuilder.loadPropertiesFromURL(neo4ConfUrl);
            }
            this.graphDatabaseService = graphDatabaseBuilder.newGraphDatabase();
        }
        catch (Exception e) {
            throw new ConnectionException("Error connecting to embedded graph", (Throwable)e);
        }
    }

    private static GraphDatabaseFactory getGraphDatabaseFactory(Configuration configuration) throws Exception {
        GraphDatabaseFactory graphDatabaseFactory;
        if (!configuration.isEmbeddedHA()) {
            graphDatabaseFactory = new GraphDatabaseFactory();
        } else {
            String classnameOfHaFactory = "org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory";
            Class<?> haFactoryClass = Class.forName(classnameOfHaFactory);
            graphDatabaseFactory = (GraphDatabaseFactory)haFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return graphDatabaseFactory;
    }

    protected String getTypeSystemName() {
        return "org.neo4j.ogm.drivers.embedded.types.EmbeddedNativeTypes";
    }

    public Function<TransactionManager, BiFunction<Transaction.Type, Iterable<String>, Transaction>> getTransactionFactorySupplier() {
        return transactionManager -> (type, bookmarks) -> {
            if (bookmarks != null && bookmarks.iterator().hasNext()) {
                this.logger.warn("Passing bookmarks {} to EmbeddedDriver. This is not currently supported.", bookmarks);
            }
            Transaction currentOGMTransaction = transactionManager.getCurrentTransaction();
            return new EmbeddedTransaction((TransactionManager)transactionManager, this.nativeTransaction(currentOGMTransaction), (Transaction.Type)type);
        };
    }

    public synchronized void close() {
        if (this.graphDatabaseService != null) {
            this.logger.info("Shutting down Embedded driver {} ", (Object)this.graphDatabaseService);
            this.graphDatabaseService.shutdown();
            this.graphDatabaseService = null;
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz == GraphDatabaseService.class) {
            return (T)this.graphDatabaseService;
        }
        return (T)super.unwrap(clazz);
    }

    public Request request(Transaction transaction) {
        return new EmbeddedRequest(this.graphDatabaseService, transaction, this.parameterConversion, new EmbeddedEntityAdapter(this.typeSystem), this.getCypherModification());
    }

    private org.neo4j.graphdb.Transaction nativeTransaction(Transaction currentOGMTransaction) {
        org.neo4j.graphdb.Transaction nativeTransaction;
        if (currentOGMTransaction != null) {
            this.logger.debug("Using current transaction: {}", (Object)currentOGMTransaction);
            nativeTransaction = ((EmbeddedTransaction)currentOGMTransaction).getNativeTransaction();
        } else {
            this.logger.debug("No current transaction, starting a new one");
            nativeTransaction = this.graphDatabaseService.beginTx();
        }
        this.logger.debug("Native transaction: {}", (Object)nativeTransaction);
        return nativeTransaction;
    }

    private String createTemporaryFileStore() {
        try {
            Path path = Files.createTempDirectory("neo4jTmpEmbedded.db", new FileAttribute[0]);
            Path databasePath = Paths.get(path.toFile().getAbsolutePath() + "/database", new String[0]);
            Files.createDirectories(databasePath, new FileAttribute[0]);
            File f = databasePath.toFile();
            URI uri = f.toURI();
            String databaseUriValue = uri.toString();
            this.logger.warn("Creating temporary file store: " + databaseUriValue);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                this.close();
                try {
                    this.logger.warn("Deleting temporary file store: " + databaseUriValue);
                    FileUtils.deleteDirectory((Path)path);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to delete temporary files in " + databaseUriValue, e);
                }
            }));
            return databaseUriValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createPermanentFileStore(String strPath) {
        try {
            URI uri = new URI(strPath);
            File file = new File(uri);
            if (!file.exists()) {
                Path graphDir = Files.createDirectories(file.toPath(), new FileAttribute[0]);
                this.logger.warn("Creating new permanent file store: " + graphDir.toString());
            }
            Runtime.getRuntime().addShutdownHook(new Thread(this::close));
        }
        catch (FileAlreadyExistsException e) {
            this.logger.warn("Using existing permanent file store: " + strPath);
        }
        catch (IOException | URISyntaxException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

