/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.response;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.neo4j.graphdb.Result;
import org.neo4j.ogm.drivers.embedded.driver.EmbeddedEntityAdapter;
import org.neo4j.ogm.drivers.embedded.response.EmbeddedResponse;
import org.neo4j.ogm.drivers.embedded.response.EmbeddedRestModelAdapter;
import org.neo4j.ogm.drivers.embedded.response.StatisticsModelAdapter;
import org.neo4j.ogm.model.QueryStatistics;
import org.neo4j.ogm.model.RestModel;
import org.neo4j.ogm.response.model.DefaultRestModel;
import org.neo4j.ogm.response.model.QueryStatisticsModel;

public class RestModelResponse
extends EmbeddedResponse<RestModel> {
    private final EmbeddedRestModelAdapter restModelAdapter;
    private final QueryStatisticsModel statisticsModel;

    public RestModelResponse(Result result, EmbeddedEntityAdapter entityAdapter) {
        super(result);
        this.restModelAdapter = new EmbeddedRestModelAdapter(entityAdapter);
        this.statisticsModel = new StatisticsModelAdapter().adapt(result);
    }

    @Override
    public RestModel next() {
        return DefaultRestModel.basedOn(this.buildModel()).orElse(null);
    }

    private Map<String, Object> buildModel() {
        Map<String, Object> row = new LinkedHashMap<String, Object>();
        if (this.result.hasNext()) {
            Map data = this.result.next();
            row = this.restModelAdapter.adapt(data);
        }
        return row;
    }

    public Optional<QueryStatistics> getStatistics() {
        return Optional.of(this.statisticsModel);
    }
}

