/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.http.response;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.neo4j.ogm.result.adapter.ResultAdapter;

public class RestModelAdapter
implements ResultAdapter<Object[], Map<String, Object>> {
    private String[] columns;

    public Map<String, Object> adapt(Object[] result) {
        LinkedHashMap<String, Object> adaptedResults = new LinkedHashMap<String, Object>();
        for (int i = 0; i < this.columns.length; ++i) {
            String column = this.columns[i];
            Object value = result[i];
            if (value instanceof Collection) {
                ArrayList adaptedValues = new ArrayList();
                List values = (List)value;
                for (Object element : values) {
                    org.neo4j.ogm.result.adapter.RestModelAdapter.handleAdaptedValue(adaptedValues, (Object)this.processData(element));
                }
                adaptedResults.put(column, adaptedValues);
                continue;
            }
            adaptedResults.put(column, this.processData(value));
        }
        return adaptedResults;
    }

    private Object processData(Object element) {
        if (element instanceof Map) {
            return this.buildEntity((Map)element);
        }
        return org.neo4j.ogm.result.adapter.RestModelAdapter.handlePossibleCollections((Object)element, this::processData);
    }

    private Object buildEntity(Map entity) {
        if (entity.containsKey("metadata") && ((Map)entity.get("metadata")).get("id") != null) {
            Map entityMetadata = (Map)entity.get("metadata");
            if (entityMetadata.containsKey("labels")) {
                List labelList = (List)entityMetadata.get("labels");
                String[] labels = new String[labelList.size()];
                labels = labelList.toArray(labels);
                NodeModel nodeModel = new NodeModel(Long.valueOf(((Number)entityMetadata.get("id")).longValue()));
                nodeModel.setProperties((Map)entity.get("data"));
                nodeModel.setLabels(labels);
                return nodeModel;
            }
            if (entityMetadata.containsKey("type")) {
                String relationshipType = (String)entityMetadata.get("type");
                RelationshipModel relationshipModel = new RelationshipModel();
                relationshipModel.setId(Long.valueOf(((Number)entityMetadata.get("id")).longValue()));
                relationshipModel.setProperties((Map)entity.get("data"));
                relationshipModel.setType(relationshipType);
                String startURL = (String)entity.get("start");
                String endURL = (String)entity.get("end");
                relationshipModel.setStartNode(Long.valueOf(startURL.substring(startURL.lastIndexOf("/") + 1)));
                relationshipModel.setEndNode(Long.valueOf(endURL.substring(endURL.lastIndexOf("/") + 1)));
                return relationshipModel;
            }
        }
        return entity;
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }
}

