/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.quarkus.deployment;

import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.TableDataPageBuilder;
import java.util.List;
import org.neo4j.ogm.quarkus.deployment.EntitiesBuildItem;

public class Neo4jOgmDevConsoleProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    CardPageBuildItem createOgmCard(EntitiesBuildItem entitiesBuildItem) {
        CardPageBuildItem ogmCard = new CardPageBuildItem();
        List<EntityDescription> entities = entitiesBuildItem.getValue().stream().map(e -> new EntityDescription(e.getPackageName(), e.getSimpleName())).toList();
        if (!entities.isEmpty()) {
            ogmCard.addBuildTimeData("entities", entities);
            ogmCard.addPage((PageBuilder)((TableDataPageBuilder)((TableDataPageBuilder)Page.tableDataPageBuilder((String)"Entities").showColumn("packageName").showColumn("simpleName").buildTimeDataKey("entities")).icon("font-awesome-solid:egg")).staticLabel(String.valueOf(entities.size())));
        }
        return ogmCard;
    }

    record EntityDescription(String packageName, String simpleName) {
    }
}

