/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.quarkus.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.neo4j.deployment.Neo4jDriverBuildItem;
import io.quarkus.neo4j.runtime.Neo4jConfiguration;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.neo4j.ogm.quarkus.deployment.EntitiesBuildItem;
import org.neo4j.ogm.quarkus.deployment.Neo4jOgmSessionFactoryBuildItem;
import org.neo4j.ogm.quarkus.runtime.Neo4jOgmBuiltTimeProperties;
import org.neo4j.ogm.quarkus.runtime.Neo4jOgmProperties;
import org.neo4j.ogm.quarkus.runtime.Neo4jOgmRecorder;
import org.neo4j.ogm.session.SessionFactory;

public class Neo4jOgmProcessor {
    private static final String FEATURE_NAME = "neo4j-ogm";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE_NAME);
    }

    @BuildStep
    EntitiesBuildItem findAnnotatedClasses(CombinedIndexBuildItem indexBuildItem, Neo4jOgmBuiltTimeProperties buildTimeProperties) throws ClassNotFoundException {
        TreeSet classes = new TreeSet(Comparator.comparing(Class::getName));
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Predicate packageFilter = buildTimeProperties.basePackages.map(packages -> n -> packages.contains(n.packagePrefix())).orElseGet(() -> n -> true);
        IndexView index = indexBuildItem.getIndex();
        DotName nodeEntity = DotName.createSimple((String)"org.neo4j.ogm.annotation.NodeEntity");
        classes.addAll(this.load(packageFilter, ccl, index.getAnnotations(nodeEntity).stream().map(ai -> ai.target().asClass()).collect(Collectors.toList())));
        DotName relationshipEntity = DotName.createSimple((String)"org.neo4j.ogm.annotation.RelationshipEntity");
        classes.addAll(this.load(packageFilter, ccl, index.getAnnotations(relationshipEntity).stream().map(ai -> ai.target().asClass()).collect(Collectors.toList())));
        return new EntitiesBuildItem(classes);
    }

    private Collection<Class<?>> load(Predicate<DotName> filter, ClassLoader classLoader, Collection<ClassInfo> candidates) throws ClassNotFoundException {
        ArrayList result = new ArrayList(candidates.size());
        for (ClassInfo classInfo : candidates) {
            if (!filter.test(classInfo.name())) continue;
            result.add(classLoader.loadClass(classInfo.name().toString()));
        }
        return result;
    }

    @BuildStep
    ReflectiveClassBuildItem registerAnnotatedClassesForReflection(EntitiesBuildItem entitiesBuildItem) {
        return ReflectiveClassBuildItem.builder((Class[])entitiesBuildItem.getValue().toArray(new Class[0])).constructors().methods().fields().build();
    }

    @BuildStep
    ReflectiveClassBuildItem registerNativeTypes() throws ClassNotFoundException {
        Class<?> typeSystem = Class.forName("org.neo4j.ogm.drivers.bolt.types.BoltNativeTypes", false, Thread.currentThread().getContextClassLoader());
        return ReflectiveClassBuildItem.builder((Class[])new Class[]{typeSystem}).constructors().build();
    }

    @BuildStep
    void createOGMIndex(EntitiesBuildItem entitiesBuildItem, BuildProducer<GeneratedResourceBuildItem> resourceProducer) {
        entitiesBuildItem.getValue().stream().collect(Collectors.groupingBy(Class::getPackageName)).forEach((p, cl) -> {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);){
                    for (Class implName : cl) {
                        w.write(implName.getName());
                        w.write(System.lineSeparator());
                    }
                    w.flush();
                }
                resourceProducer.produce((BuildItem)new GeneratedResourceBuildItem(Neo4jOgmProcessor.packageAsIndexEntry(p), os.toByteArray()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @BuildStep
    NativeImageResourceBuildItem addIndizesToNativeImage(EntitiesBuildItem entitiesBuildItem) {
        List allGeneratedResources = entitiesBuildItem.getValue().stream().map(Class::getPackageName).distinct().map(Neo4jOgmProcessor::packageAsIndexEntry).collect(Collectors.toList());
        return new NativeImageResourceBuildItem(allGeneratedResources);
    }

    static String packageAsIndexEntry(String p) {
        return "META-INF/resources/" + p.replace(".", "/") + "/neo4j-ogm.index";
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    Neo4jOgmSessionFactoryBuildItem createSessionFactory(Neo4jOgmRecorder recorder, Neo4jDriverBuildItem driverBuildItem, ShutdownContextBuildItem shutdownContext, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, Neo4jConfiguration neo4jConfiguration, Neo4jOgmProperties ogmProperties, Neo4jOgmBuiltTimeProperties buildTimeProperties, EntitiesBuildItem allClasses) {
        String[] allPackages = (String[])allClasses.getValue().stream().map(Class::getPackageName).distinct().toArray(String[]::new);
        if (allPackages.length == 0 && buildTimeProperties.basePackages.isPresent()) {
            allPackages = ((List)buildTimeProperties.basePackages.get()).toArray(new String[0]);
        }
        RuntimeValue sessionFactoryRuntimeValue = recorder.initializeSessionFactory(driverBuildItem.getValue(), (ShutdownContext)shutdownContext, neo4jConfiguration, ogmProperties, allPackages);
        SyntheticBeanBuildItem beanBuildItem = SyntheticBeanBuildItem.configure(SessionFactory.class).runtimeValue(sessionFactoryRuntimeValue).setRuntimeInit().done();
        syntheticBeans.produce((BuildItem)beanBuildItem);
        return new Neo4jOgmSessionFactoryBuildItem((RuntimeValue<SessionFactory>)sessionFactoryRuntimeValue);
    }
}

