/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.conversion;

import java.util.Optional;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.support.ClassUtils;
import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.typeconversion.ProxyAttributeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;

public class MetaDataDrivenConversionService
extends GenericConversionService {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataDrivenConversionService.class);

    public MetaDataDrivenConversionService(MetaData metaData) {
        for (ClassInfo classInfo : metaData.persistentEntities()) {
            for (FieldInfo fieldInfo : classInfo.propertyFields()) {
                if (!fieldInfo.hasPropertyConverter()) continue;
                this.addWrappedConverter(fieldInfo.getField().getType(), fieldInfo.getPropertyConverter());
            }
        }
    }

    private void addWrappedConverter(Class<?> type, AttributeConverter attributeConverter) {
        if (attributeConverter instanceof ProxyAttributeConverter) {
            return;
        }
        EntityToGraphTypeMapping entityToGraphTypeMapping = MetaDataDrivenConversionService.getEntityToGraphTypeMapping(type, attributeConverter);
        if (this.canConvert(entityToGraphTypeMapping.entityType, entityToGraphTypeMapping.graphType) && this.canConvert(entityToGraphTypeMapping.graphType, entityToGraphTypeMapping.entityType)) {
            logger.debug("Not adding Spring-compatible converter for " + String.valueOf(attributeConverter.getClass()) + " because one that does the same job has already been registered with the ConversionService.");
        } else {
            Converter toGraphConverter = arg_0 -> ((AttributeConverter)attributeConverter).toGraphProperty(arg_0);
            Converter toEntityConverter = arg_0 -> ((AttributeConverter)attributeConverter).toEntityAttribute(arg_0);
            this.addConverter(entityToGraphTypeMapping.entityType, entityToGraphTypeMapping.graphType, toGraphConverter);
            this.addConverter(entityToGraphTypeMapping.graphType, entityToGraphTypeMapping.entityType, toEntityConverter);
        }
    }

    static EntityToGraphTypeMapping getEntityToGraphTypeMapping(Class<?> type, AttributeConverter attributeConverter) {
        ResolvableType resolvableType = ResolvableType.forClass(AttributeConverter.class, attributeConverter.getClass());
        if (!resolvableType.hasGenerics()) {
            throw new IllegalStateException("Cannot resolve source and target types for the given attribute converter of class " + String.valueOf(attributeConverter.getClass()));
        }
        Class<?> sourceType = ClassUtils.isEnum(type) ? type : MetaDataDrivenConversionService.nestedTypeOrType(resolvableType.getGeneric(new int[]{0}));
        Class<?> targetType = MetaDataDrivenConversionService.nestedTypeOrType(resolvableType.getGeneric(new int[]{1}));
        return new EntityToGraphTypeMapping(sourceType, targetType);
    }

    private static Class<?> nestedTypeOrType(ResolvableType type) {
        return Optional.ofNullable(type.asCollection()).filter(ResolvableType::hasGenerics).map(r -> r.getGeneric(new int[]{0})).orElse(type).resolve(Object.class);
    }

    static class EntityToGraphTypeMapping {
        Class<?> entityType;
        Class<?> graphType;

        private EntityToGraphTypeMapping(Class<?> entityType, Class<?> target) {
            this.entityType = entityType;
            this.graphType = target;
        }
    }
}

