/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.config;

import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.session.EntityInstantiator;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.typeconversion.ConversionCallback;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.conversion.MetaDataDrivenConversionService;
import org.springframework.data.neo4j.conversion.Neo4jOgmEntityInstantiatorAdapter;
import org.springframework.data.neo4j.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;

class Neo4jOgmEntityInstantiatorConfigurationBean
implements InitializingBean {
    private final SessionFactory sessionFactory;
    private final Neo4jMappingContext mappingContext;
    private final ObjectProvider<ConversionService> conversionServiceObjectProvider;

    public Neo4jOgmEntityInstantiatorConfigurationBean(SessionFactory sessionFactory, Neo4jMappingContext mappingContext, ObjectProvider<ConversionService> conversionServiceObjectProvider) {
        this.sessionFactory = sessionFactory;
        this.mappingContext = mappingContext;
        this.conversionServiceObjectProvider = conversionServiceObjectProvider;
    }

    public void afterPropertiesSet() {
        MetaData metaData = this.sessionFactory.metaData();
        ConversionService conversionService = (ConversionService)this.conversionServiceObjectProvider.getIfUnique(() -> new MetaDataDrivenConversionService(metaData));
        metaData.registerConversionCallback((ConversionCallback)new ConversionServiceBasedConversionCallback(conversionService));
        this.sessionFactory.setEntityInstantiator((EntityInstantiator)new Neo4jOgmEntityInstantiatorAdapter((MappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty>)this.mappingContext, conversionService));
    }

    private static class ConversionServiceBasedConversionCallback
    implements ConversionCallback {
        private final ConversionService delegate;

        public ConversionServiceBasedConversionCallback(ConversionService conversionService) {
            this.delegate = conversionService;
        }

        public <T> T convert(Class<T> targetType, Object value) {
            if (value == null) {
                return null;
            }
            return (T)this.delegate.convert(value, targetType);
        }
    }
}

