/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.neo4j.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.TemplatedQuery;
import org.springframework.data.neo4j.repository.query.filter.FilterBuilder;
import org.springframework.data.repository.query.parser.Part;

class FilterBuildersDefinition {
    private final Class<?> entityType;
    private final Part basePart;
    private final List<FilterBuilder> filterBuilders;
    private final Predicate<Part> isInternalIdProperty;

    static UnstartedBuild forType(Neo4jMappingContext mappingContext, Class<?> entityType) {
        return new UnstartedBuild(mappingContext, entityType);
    }

    private FilterBuildersDefinition(Neo4jMappingContext mappingContext, Class<?> entityType, Part basePart) {
        this.entityType = entityType;
        this.basePart = basePart;
        this.filterBuilders = new LinkedList<FilterBuilder>();
        this.isInternalIdProperty = part -> {
            PersistentPropertyPath path = mappingContext.getPersistentPropertyPath(part.getProperty());
            Neo4jPersistentProperty possibleIdProperty = (Neo4jPersistentProperty)path.getLeafProperty();
            return possibleIdProperty.isInternalIdProperty();
        };
        this.filterBuilders.add(FilterBuilder.forPartAndEntity(basePart, entityType, BooleanOperator.NONE, this.isInternalIdProperty));
    }

    TemplatedQuery buildTemplatedQuery() {
        return new TemplatedQuery(Collections.unmodifiableList(this.filterBuilders));
    }

    Part getBasePart() {
        return this.basePart;
    }

    FilterBuildersDefinition and(Part part) {
        this.filterBuilders.add(FilterBuilder.forPartAndEntity(part, this.entityType, BooleanOperator.AND, this.isInternalIdProperty));
        return this;
    }

    FilterBuildersDefinition or(Part part) {
        this.filterBuilders.add(FilterBuilder.forPartAndEntity(part, this.entityType, BooleanOperator.OR, this.isInternalIdProperty));
        return this;
    }

    static class UnstartedBuild {
        private final Neo4jMappingContext mappingContext;
        private final Class<?> entityType;

        UnstartedBuild(Neo4jMappingContext mappingContext, Class<?> entityType) {
            this.mappingContext = mappingContext;
            this.entityType = entityType;
        }

        FilterBuildersDefinition startWith(Part firstPart) {
            return new FilterBuildersDefinition(this.mappingContext, this.entityType, firstPart);
        }
    }
}

