/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.neo4j.annotation.Depth;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.util.TypeInformation;

public class GraphParameters
extends Parameters<GraphParameters, GraphParameter> {
    private final int depthIndex;

    GraphParameters(ParametersSource parametersSource) {
        super(parametersSource, GraphParameter::new);
        List<GraphParameter> depthParameter = super.stream().filter(GraphParameter::isDepthParameter).toList();
        if (depthParameter.size() > 1) {
            throw new IllegalStateException(String.format("Found multiple @Depth annotations on method %s! Only one allowed!", parametersSource.getMethod()));
        }
        this.depthIndex = depthParameter.isEmpty() ? -1 : depthParameter.get(0).getIndex();
    }

    private GraphParameters(List<GraphParameter> originals, int depthIndex) {
        super(originals);
        this.depthIndex = depthIndex;
    }

    protected GraphParameters createFrom(List<GraphParameter> parameters) {
        return new GraphParameters(parameters, this.depthIndex);
    }

    int getDepthIndex() {
        return this.depthIndex;
    }

    static class GraphParameter
    extends Parameter {
        private final MethodParameter parameter;

        GraphParameter(MethodParameter parameter) {
            super(parameter, TypeInformation.of(Parameter.class));
            this.parameter = parameter;
        }

        public boolean isSpecialParameter() {
            return super.isSpecialParameter() || Distance.class.isAssignableFrom(this.getType()) || this.parameter.getParameterAnnotation(Depth.class) != null || Distance.class.isAssignableFrom(this.getType()) || Point.class.isAssignableFrom(this.getType());
        }

        boolean isDepthParameter() {
            return this.parameter.getParameterAnnotation(Depth.class) != null;
        }
    }
}

