/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.Method;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.session.Session;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.mapping.MetaDataProvider;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.GraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.NamedGraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.PartTreeNeo4jQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodValueEvaluationContextAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public class GraphQueryLookupStrategy
implements QueryLookupStrategy {
    private final MetaData metaData;
    private final Session session;
    private final QueryMethodValueEvaluationContextAccessor evaluationContextProvider;
    private final MappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty> mappingContext;

    public GraphQueryLookupStrategy(Session session, QueryMethodValueEvaluationContextAccessor evaluationContextProvider, @Nullable MappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty> mappingContext) {
        this.metaData = GraphQueryLookupStrategy.getMetaData(session);
        this.session = session;
        this.evaluationContextProvider = evaluationContextProvider;
        this.mappingContext = mappingContext;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        GraphQueryMethod queryMethod = new GraphQueryMethod(method, metadata, factory);
        queryMethod.setMappingContext(this.mappingContext);
        String namedQueryName = queryMethod.getNamedQueryName();
        String namedCountQueryName = queryMethod.getNamedCountQueryName();
        if (namedQueries.hasQuery(namedQueryName)) {
            String cypherQuery = namedQueries.getQuery(namedQueryName);
            if (namedQueries.hasQuery(namedCountQueryName)) {
                String countQuery = namedQueries.getQuery(namedCountQueryName);
                return new NamedGraphRepositoryQuery(queryMethod, this.metaData, this.session, cypherQuery, countQuery, this.evaluationContextProvider);
            }
            return new NamedGraphRepositoryQuery(queryMethod, this.metaData, this.session, cypherQuery, this.evaluationContextProvider);
        }
        if (queryMethod.hasAnnotatedQuery()) {
            return new GraphRepositoryQuery(queryMethod, this.metaData, this.session, this.evaluationContextProvider);
        }
        return new PartTreeNeo4jQuery(queryMethod, this.metaData, this.session);
    }

    private static MetaData getMetaData(Session session) {
        if (session instanceof MetaDataProvider) {
            return ((MetaDataProvider)session).getMetaData();
        }
        Method getMetaData = ReflectionUtils.findMethod(session.getClass(), (String)"metaData");
        if (getMetaData == null) {
            throw new IllegalStateException("Could not retrieve Neo4j-OGM MetaData from session.");
        }
        return (MetaData)ReflectionUtils.invokeMethod((Method)getMetaData, (Object)session);
    }
}

