/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.spel;

import java.util.Map;
import java.util.function.BiFunction;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.neo4j.repository.query.spel.Neo4jQueryPlaceholderSupplier;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodValueEvaluationContextAccessor;
import org.springframework.data.repository.query.ValueExpressionQueryRewriter;

public class ParameterizedQuery {
    private final Parameters<?, ?> methodParameters;
    private final ValueExpressionQueryRewriter.QueryExpressionEvaluator expressionEvaluator;

    private ParameterizedQuery(Parameters<?, ?> methodParameters, ValueExpressionQueryRewriter.QueryExpressionEvaluator expressionEvaluator) {
        this.methodParameters = methodParameters;
        this.expressionEvaluator = expressionEvaluator;
    }

    public static ParameterizedQuery getParameterizedQuery(String queryString, Parameters<?, ?> methodParameters, QueryMethodValueEvaluationContextAccessor evaluationContextProvider) {
        Neo4jQueryPlaceholderSupplier supplier = new Neo4jQueryPlaceholderSupplier();
        ValueExpressionQueryRewriter.EvaluatingValueExpressionQueryRewriter rewriter = ValueExpressionQueryRewriter.of((ValueExpressionParser)ValueExpressionParser.create(), (index, prefix) -> supplier.parameterName((int)index), (prefix, name) -> supplier.decoratePlaceholder((String)name)).withEvaluationContextAccessor(evaluationContextProvider);
        return new ParameterizedQuery(methodParameters, rewriter.parse(queryString, methodParameters));
    }

    public Map<String, Object> resolveParameter(Object[] parameters, BiFunction<Parameters<?, ?>, Object[], Map<String, Object>> nativePlaceholderFunction) {
        Map parameterValues = this.expressionEvaluator.evaluate(parameters);
        Map<String, Object> nativeParameterValues = nativePlaceholderFunction.apply(this.methodParameters, parameters);
        parameterValues.putAll(nativeParameterValues);
        return parameterValues;
    }

    public String getQueryString() {
        return this.expressionEvaluator.getQueryString();
    }
}

