/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.springframework.data.repository.core.support.AbstractEntityInformation;

public class GraphEntityInformation<T, ID>
extends AbstractEntityInformation<T, ID> {
    private final MetaData metaData;

    public GraphEntityInformation(MetaData metaData, Class<T> type) {
        super(type);
        this.metaData = metaData;
    }

    public ID getId(T entity) {
        ClassInfo classInfo = this.metaData.classInfo(this.getJavaType().getName());
        FieldInfo primaryIndex = classInfo.primaryIndexField();
        return (ID)this.getId(entity, classInfo, primaryIndex);
    }

    private Object getId(T entity, ClassInfo classInfo, FieldInfo primaryIndex) {
        if (primaryIndex != null) {
            return classInfo.propertyField(primaryIndex.getName()).readProperty(entity);
        }
        return classInfo.propertyField(classInfo.identityField().getName()).readProperty(entity);
    }

    public Class<ID> getIdType() {
        FieldInfo primaryIndex = this.metaData.classInfo(this.getJavaType().getName()).primaryIndexField();
        if (primaryIndex != null) {
            return primaryIndex.convertedType();
        }
        return Long.class;
    }
}

