/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import java.util.Optional;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.GraphQueryLookupStrategy;
import org.springframework.data.neo4j.repository.support.GraphEntityInformation;
import org.springframework.data.neo4j.repository.support.SimpleNeo4jRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Neo4jRepositoryFactory
extends RepositoryFactorySupport {
    private static final Logger logger = LoggerFactory.getLogger(Neo4jRepositoryFactory.class);
    private final Session session;
    @Nullable
    private final MappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty> mappingContext;

    @Deprecated
    public Neo4jRepositoryFactory(Session session) {
        this(session, null);
    }

    public Neo4jRepositoryFactory(Session session, MappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty> mappingContext) {
        Assert.notNull((Object)session, (String)"Session must not be null!");
        this.session = session;
        if (mappingContext != null) {
            this.mappingContext = mappingContext;
        } else if (session instanceof Neo4jSession) {
            logger.debug("Creating a new mapping context");
            this.mappingContext = new Neo4jMappingContext(((Neo4jSession)session).metaData());
            ((Neo4jMappingContext)this.mappingContext).initialize();
        } else {
            logger.warn("No mapping context present, some operations won't support persistence constructors");
            this.mappingContext = null;
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> type) {
        Assert.notNull(type, (String)"Domain class must not be null!");
        return new GraphEntityInformation(((Neo4jSession)this.session).metaData(), type);
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        return this.getTargetRepositoryViaReflection(information, new Object[]{information.getDomainType(), this.session});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        return SimpleNeo4jRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        return Optional.of(new GraphQueryLookupStrategy(this.session, valueExpressionDelegate.getEvaluationContextAccessor(), this.mappingContext));
    }
}

