/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.testutil;

import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilder;
import org.neo4j.ogm.testutil.TestUtils;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.database.Database;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestServer.class);
    private final Integer port;
    private final Integer transactionTimeoutSeconds;
    private final Boolean enableAuthentication;
    private final Boolean enableBolt;
    private GraphDatabaseService database;
    private ServerControls controls;
    private String username;
    private String password;
    private String uri;

    public TestServer(boolean enableAuthentication, boolean enableBolt, int transactionTimeoutSeconds) {
        this(enableAuthentication, enableBolt, transactionTimeoutSeconds, TestUtils.getAvailablePort());
    }

    public TestServer(boolean enableAuthentication, boolean enableBolt, int transactionTimeoutSeconds, int port) {
        this.port = port;
        this.transactionTimeoutSeconds = transactionTimeoutSeconds;
        this.enableAuthentication = enableAuthentication;
        this.enableBolt = enableBolt;
        this.startServer();
        LOGGER.info("Starting {} server on: {}", (Object)(enableBolt ? "BOLT" : "HTTP"), (Object)port);
    }

    public static TestServerBuilder newInProcessBuilder() {
        TestServerBuilder builder = TestServer.instantiate("org.neo4j.harness.internal.EnterpriseInProcessServerBuilder");
        if (builder == null) {
            builder = TestServer.instantiate("org.neo4j.harness.EnterpriseInProcessServerBuilder");
        }
        if (builder == null) {
            builder = TestServer.instantiate("org.neo4j.harness.internal.InProcessServerBuilder");
        }
        builder = builder.withConfig("unsupported.dbms.jmx_module.enabled", "false");
        LOGGER.info("Creating new instance of {}", builder.getClass());
        return builder;
    }

    private static TestServerBuilder instantiate(String className) {
        TestServerBuilder builder = null;
        try {
            builder = (TestServerBuilder)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOGGER.trace("Could not load {}", (Object)className, (Object)e);
        }
        return builder;
    }

    public void startServer() {
        try {
            this.controls = this.enableBolt != false ? TestServer.newInProcessBuilder().withConfig("dbms.connector.bolt.type", "BOLT").withConfig("dbms.connector.bolt.enabled", "true").withConfig("dbms.connector.bolt.listen_address", "localhost:" + String.valueOf(this.port)).newServer() : TestServer.newInProcessBuilder().withConfig("dbms.connector.http.type", "HTTP").withConfig("dbms.connector.http.enabled", "true").withConfig("dbms.connector.http.listen_address", "localhost:" + String.valueOf(this.port)).withConfig("dbms.security.auth_enabled", String.valueOf(this.enableAuthentication)).withConfig("org.neo4j.server.webserver.port", String.valueOf(this.port)).withConfig("org.neo4j.server.transaction.timeout", String.valueOf(this.transactionTimeoutSeconds)).withConfig("dbms.transaction_timeout", String.valueOf(this.transactionTimeoutSeconds)).withConfig("dbms.security.auth_store.location", this.createAuthStore()).withConfig("unsupported.dbms.security.auth_store.location", this.createAuthStore()).withConfig("remote_shell_enabled", "false").newServer();
            this.initialise(this.controls);
            Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
        }
        catch (Exception e) {
            throw new RuntimeException("Error starting in-process server", e);
        }
    }

    private String createAuthStore() {
        try {
            Path authStore = Files.createTempFile("neo4j", "credentials", new FileAttribute[0]);
            authStore.toFile().deleteOnExit();
            if (this.enableAuthentication.booleanValue()) {
                try (FileWriter authStoreWriter = new FileWriter(authStore.toFile());){
                    IOUtils.write((String)"neo4j:SHA-256,03C9C54BF6EEF1FF3DFEB75403401AA0EBA97860CAC187D6452A1FCF4C63353A,819BDB957119F8DFFF65604C92980A91:", (Writer)authStoreWriter);
                }
                this.username = "neo4j";
                this.password = "password";
            }
            return authStore.toAbsolutePath().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initialise(ServerControls controls) throws Exception {
        this.setDatabase(controls);
        this.uri = this.url();
    }

    private void setDatabase(ServerControls controls) throws Exception {
        try {
            Method method = controls.getClass().getMethod("graph", new Class[0]);
            this.database = (GraphDatabaseService)method.invoke((Object)controls, new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
            Class<?> clazz = Class.forName("org.neo4j.harness.internal.InProcessServerControls");
            Field field = clazz.getDeclaredField("server");
            field.setAccessible(true);
            AbstractNeoServer server = (AbstractNeoServer)field.get(controls);
            Database db = server.getDatabase();
            this.database = db.getGraph();
        }
    }

    public void shutdown() {
        if (this.database != null && this.database.isAvailable(100L)) {
            LOGGER.info("Stopping {} server on: {}", (Object)(this.enableBolt != false ? "BOLT" : "HTTP"), (Object)this.port);
            this.database.shutdown();
            this.database = null;
        }
        this.controls.close();
    }

    boolean isRunning() {
        return this.database.isAvailable(1000L);
    }

    private String url() {
        try {
            Method method = this.enableBolt != false ? this.controls.getClass().getMethod("boltURI", new Class[0]) : this.controls.getClass().getMethod("httpURI", new Class[0]);
            Object url = method.invoke((Object)this.controls, new Object[0]);
            return url.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public GraphDatabaseService getGraphDatabaseService() {
        return this.database;
    }

    public String getUri() {
        return this.uri;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }
}

