/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.spi.CypherModificationProvider;
import org.neo4j.ogm.transaction.Transaction;

public class CypherModificationSPITest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void abstractDriverShouldLoadCypherModificationsInCorrectOrder() {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(new TestServiceLoaderClassLoader(originalClassLoader));
        Configuration driverConfiguration = new Configuration.Builder().withCustomProperty("config1", (Object)6).withCustomProperty("config2", (Object)9).build();
        TestDriver driver = new TestDriver();
        driver.configure(driverConfiguration);
        try {
            Function cypherModification = driver.getCypherModification();
            Assertions.assertThat((String)((String)cypherModification.apply("What do you get if you multiply six by nine?"))).isEqualTo((Object)"42");
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    @Test
    public void driverShouldProvideNoopModificationWithoutAnyProvider() {
        TestDriver driver = new TestDriver();
        driver.configure(new Configuration.Builder().build());
        Function cypherModification = driver.getCypherModification();
        String cypher = "MATCH (n) RETURN n";
        Assertions.assertThat((String)((String)cypherModification.apply(cypher))).isEqualTo((Object)cypher);
    }

    @Test
    public void driverShouldNotProvideModificationWithoutConfiguration() {
        TestDriver driver = new TestDriver();
        Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> ((Driver)driver).getCypherModification()).withMessage("Driver is not configured and cannot load Cypher modifications.").withNoCause();
    }

    private static class TestServiceLoaderClassLoader
    extends ClassLoader {
        public TestServiceLoaderClassLoader(ClassLoader originalClassLoader) {
            super(originalClassLoader);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if ("META-INF/services/org.neo4j.ogm.spi.CypherModificationProvider".equals(name)) {
                return Collections.enumeration(Arrays.asList(super.getResource("spi/cypher_modification1"), super.getResource("spi/cypher_modification2")));
            }
            return super.getResources(name);
        }
    }

    private static class TestDriver
    extends AbstractConfigurableDriver {
        private TestDriver() {
        }

        public void close() {
        }

        public Request request(Transaction transaction) {
            return null;
        }
    }

    public static class CypherModificationProvider2
    implements CypherModificationProvider {
        public int getOrder() {
            return 10;
        }

        public Function<String, String> getCypherModification(Map<String, Object> configuration) {
            return originalCypher -> "theAnswer";
        }
    }

    public static class CypherModificationProvider1
    implements CypherModificationProvider {
        public int getOrder() {
            return 20;
        }

        public Function<String, String> getCypherModification(Map<String, Object> configuration) {
            Integer value1 = (Integer)configuration.get("config1");
            Integer value2 = (Integer)configuration.get("config2");
            return modifiedCypher -> modifiedCypher.replaceAll("theAnswer", Integer.toString(value1 * value2, 13));
        }
    }
}

