/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.autoindex;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.autoindex.BaseAutoIndexManagerTestClass;
import org.neo4j.ogm.domain.autoindex.NodeKeyConstraintEntity;

public class NodeKeyConstraintIndexAutoIndexManagerTest
extends BaseAutoIndexManagerTestClass {
    private static final String CONSTRAINT = "CONSTRAINT ON (`entity`:`Entity`) ASSERT (`entity`.`name`,`entity`.`age`) IS NODE KEY";
    private static final String INDEX = "INDEX ON :`Entity`(`name`,`age`)";

    public NodeKeyConstraintIndexAutoIndexManagerTest() {
        super(new String[]{CONSTRAINT}, NodeKeyConstraintEntity.class);
    }

    @BeforeClass
    public static void setUpClass() {
        Assume.assumeTrue((String)"This test uses composite index and node key constraint and can only be run on enterprise edition", (boolean)NodeKeyConstraintIndexAutoIndexManagerTest.isEnterpriseEdition());
        Assume.assumeTrue((String)"This tests uses composite index and can only be run on Neo4j 3.2.0 and later", (boolean)NodeKeyConstraintIndexAutoIndexManagerTest.isVersionOrGreater((String)"3.2.0"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.executeDrop(INDEX);
    }

    @Test
    public void testAutoIndexManagerUpdateConstraintChangedToIndex() throws Exception {
        this.executeCreate(INDEX);
        this.runAutoIndex("update");
        this.executeForIndexes(indexes -> Assertions.assertThat((List)indexes).isEmpty());
        this.executeForConstraints(constraints -> Assertions.assertThat((List)constraints).hasSize(1));
    }
}

