/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.config.AutoIndexMode;
import org.neo4j.ogm.config.ClasspathConfigurationSource;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.config.ConfigurationSource;
import org.neo4j.ogm.config.Credentials;
import org.neo4j.ogm.config.FileConfigurationSource;
import org.neo4j.ogm.config.UsernamePasswordCredentials;

public class ConfigurationTest {
    @Test
    public void shouldConfigureProgrammatically() {
        Configuration.Builder builder = new Configuration.Builder();
        builder.autoIndex("assert");
        builder.generatedIndexesOutputDir("dir");
        builder.generatedIndexesOutputFilename("filename");
        builder.credentials("fred", "flintstone");
        builder.uri("http://localhost:8080");
        builder.connectionPoolSize(Integer.valueOf(200));
        builder.encryptionLevel("REQUIRED");
        builder.trustStrategy("TRUST_SIGNED_CERTIFICATES");
        builder.trustCertFile("/tmp/cert");
        builder.connectionLivenessCheckTimeout(Integer.valueOf(1000));
        Configuration configuration = builder.build();
        Assertions.assertThat((Comparable)configuration.getAutoIndex()).isEqualTo((Object)AutoIndexMode.ASSERT);
        Assertions.assertThat((String)configuration.getDumpDir()).isEqualTo((Object)"dir");
        Assertions.assertThat((String)configuration.getDumpFilename()).isEqualTo((Object)"filename");
        Assertions.assertThat((String)configuration.getDriverClassName()).isEqualTo((Object)"org.neo4j.ogm.drivers.http.driver.HttpDriver");
        Assertions.assertThat((String)configuration.getCredentials().credentials().toString()).isEqualTo((Object)"ZnJlZDpmbGludHN0b25l");
        Assertions.assertThat((String)configuration.getURI()).isEqualTo((Object)"http://localhost:8080");
        Assertions.assertThat((int)configuration.getConnectionPoolSize()).isEqualTo(200);
        Assertions.assertThat((String)configuration.getEncryptionLevel()).isEqualTo((Object)"REQUIRED");
        Assertions.assertThat((String)configuration.getTrustStrategy()).isEqualTo((Object)"TRUST_SIGNED_CERTIFICATES");
        Assertions.assertThat((String)configuration.getTrustCertFile()).isEqualTo((Object)"/tmp/cert");
        Assertions.assertThat((int)configuration.getConnectionLivenessCheckTimeout()).isEqualTo(1000);
    }

    @Test
    public void shouldConfigureCredentialsFromURI() {
        Configuration configuration = new Configuration.Builder().uri("http://fred:flintstone@localhost:8080").build();
        Assertions.assertThat((String)configuration.getCredentials().credentials().toString()).isEqualTo((Object)"ZnJlZDpmbGludHN0b25l");
        Assertions.assertThat((String)configuration.getURI()).isEqualTo((Object)"http://localhost:8080");
    }

    @Test
    public void shouldConfigureCredentialsFromURIWithUTF8Characters() {
        Configuration configuration = new Configuration.Builder().uri("http://franti\u0161ek:Pass123@localhost:8080").build();
        Assertions.assertThat((String)configuration.getCredentials().credentials().toString()).isEqualTo((Object)"ZnJhbnRpxaFlazpQYXNzMTIz");
    }

    @Test
    public void shouldConfigureFromSimplePropertiesFile() {
        Configuration configuration = new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource("ogm-simple.properties")).build();
        Assertions.assertThat((Comparable)configuration.getAutoIndex()).isEqualTo((Object)AutoIndexMode.NONE);
        Assertions.assertThat((String)configuration.getDriverClassName()).isEqualTo((Object)"org.neo4j.ogm.drivers.http.driver.HttpDriver");
        Assertions.assertThat((String)configuration.getCredentials().credentials().toString()).isEqualTo((Object)"bmVvNGo6cGFzc3dvcmQ=");
        Assertions.assertThat((String)configuration.getURI()).isEqualTo((Object)"http://localhost:7474");
    }

    @Test
    public void shouldConfigureFromFilesystemPropertiesFilePath() throws Exception {
        File file = new File(this.getConfigFileAsRelativePath());
        FileConfigurationSource source = new FileConfigurationSource(file.getAbsolutePath());
        Configuration configuration = new Configuration.Builder((ConfigurationSource)source).build();
        Assertions.assertThat((Comparable)configuration.getAutoIndex()).isEqualTo((Object)AutoIndexMode.NONE);
        Assertions.assertThat((String)configuration.getDriverClassName()).isEqualTo((Object)"org.neo4j.ogm.drivers.http.driver.HttpDriver");
        Assertions.assertThat((String)configuration.getCredentials().credentials().toString()).isEqualTo((Object)"bmVvNGo6cGFzc3dvcmQ=");
        Assertions.assertThat((String)configuration.getURI()).isEqualTo((Object)"http://localhost:7474");
    }

    @Test
    public void shouldConfigureFromFilesystemPropertiesFileURI() throws Exception {
        File file = new File(this.getConfigFileAsRelativePath());
        FileConfigurationSource source = new FileConfigurationSource(file.toURI().toString());
        Configuration configuration = new Configuration.Builder((ConfigurationSource)source).build();
        Assertions.assertThat((Comparable)configuration.getAutoIndex()).isEqualTo((Object)AutoIndexMode.NONE);
        Assertions.assertThat((String)configuration.getDriverClassName()).isEqualTo((Object)"org.neo4j.ogm.drivers.http.driver.HttpDriver");
        Assertions.assertThat((String)configuration.getCredentials().credentials().toString()).isEqualTo((Object)"bmVvNGo6cGFzc3dvcmQ=");
        Assertions.assertThat((String)configuration.getURI()).isEqualTo((Object)"http://localhost:7474");
    }

    private String getConfigFileAsRelativePath() {
        try {
            File tempFile = File.createTempFile("ogm-simple", ".properties");
            try (InputStream in = ConfigurationTest.class.getResourceAsStream("/ogm-simple.properties");){
                Files.copy(in, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                tempFile.deleteOnExit();
            }
            return tempFile.getPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temp ogm-simple.properties", e);
        }
    }

    @Test(expected=RuntimeException.class)
    public void uriWithNoScheme() {
        Configuration configuration = new Configuration.Builder().uri("target/noe4j/my.db").build();
        Assertions.fail((String)"Should have thrown a runtime exception about a missing URI Scheme");
    }

    @Test
    public void shouldConfigureFromNameSpacePropertiesFile() {
        Configuration configuration = new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource("ogm-namespace.properties")).build();
        Assertions.assertThat((Comparable)configuration.getAutoIndex()).isEqualTo((Object)AutoIndexMode.DUMP);
        Assertions.assertThat((String)configuration.getDumpDir()).isEqualTo((Object)"hello");
        Assertions.assertThat((String)configuration.getDumpFilename()).isEqualTo((Object)"generated-indexes2.cql");
        Assertions.assertThat((String)configuration.getDriverClassName()).isEqualTo((Object)"org.neo4j.ogm.drivers.http.driver.HttpDriver");
        Assertions.assertThat((String)configuration.getCredentials().credentials().toString()).isEqualTo((Object)"bmVvNGo6cGFzc3dvcmQ=");
        Assertions.assertThat((String)configuration.getURI()).isEqualTo((Object)"http://localhost:7474");
        Assertions.assertThat((int)configuration.getConnectionPoolSize()).isEqualTo(100);
        Assertions.assertThat((String)configuration.getEncryptionLevel()).isEqualTo((Object)"NONE");
        Assertions.assertThat((String)configuration.getTrustStrategy()).isEqualTo((Object)"TRUST_ON_FIRST_USE");
        Assertions.assertThat((String)configuration.getTrustCertFile()).isEqualTo((Object)"/tmp/cert");
    }

    @Test
    public void shouldConfigureFromUsernamePasswordProperties() {
        Configuration configuration = new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource("ogm-password.properties")).build();
        Assertions.assertThat((String)((UsernamePasswordCredentials)configuration.getCredentials()).getUsername()).isEqualTo((Object)"azerty");
        Assertions.assertThat((String)((UsernamePasswordCredentials)configuration.getCredentials()).getPassword()).isEqualTo((Object)"uiop");
    }

    @Test
    public void shouldSetUsernameAndPasswordCredentialsForBoltProtocol() {
        String username = "neo4j";
        String password = "password";
        Configuration dbConfig = new Configuration.Builder().uri("bolt://" + username + ":" + password + "@localhost").build();
        Credentials credentials = dbConfig.getCredentials();
        UsernamePasswordCredentials basic = (UsernamePasswordCredentials)credentials;
        Assertions.assertThat((Object)basic).isNotNull();
        Assertions.assertThat((String)basic.getUsername()).isEqualTo((Object)username);
        Assertions.assertThat((String)basic.getPassword()).isEqualTo((Object)password);
    }

    @Test
    public void shouldConfigureFromSpringBootPropertiesFile() {
        Configuration configuration = new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource("application.properties")).build();
        Assertions.assertThat((Comparable)configuration.getAutoIndex()).isEqualTo((Object)AutoIndexMode.NONE);
        Assertions.assertThat((String)configuration.getDriverClassName()).isEqualTo((Object)"org.neo4j.ogm.drivers.http.driver.HttpDriver");
        Assertions.assertThat((String)configuration.getCredentials().credentials().toString()).isEqualTo((Object)"bmVvNGo6cGFzc3dvcmQ=");
        Assertions.assertThat((String)configuration.getURI()).isEqualTo((Object)"http://localhost:7474");
    }

    @Test
    public void shouldParseBoltUriSchemesCaseInsensitive() {
        Configuration configuration = new Configuration.Builder().uri("BOLT://localhost").build();
        Assertions.assertThat((String)configuration.getDriverClassName()).isEqualTo((Object)"org.neo4j.ogm.drivers.bolt.driver.BoltDriver");
        Assertions.assertThat((String)configuration.getURI()).isEqualTo((Object)"BOLT://localhost");
        configuration = new Configuration.Builder().uri("BOLT+ROUTING://localhost").build();
        Assertions.assertThat((String)configuration.getDriverClassName()).isEqualTo((Object)"org.neo4j.ogm.drivers.bolt.driver.BoltDriver");
        Assertions.assertThat((String)configuration.getURI()).isEqualTo((Object)"BOLT+ROUTING://localhost");
    }

    @Test
    public void shouldParseHttpUriSchemesCaseInsensitive() {
        Configuration configuration = new Configuration.Builder().uri("HTTP://localhost").build();
        Assertions.assertThat((String)configuration.getDriverClassName()).isEqualTo((Object)"org.neo4j.ogm.drivers.http.driver.HttpDriver");
        Assertions.assertThat((String)configuration.getURI()).isEqualTo((Object)"HTTP://localhost");
        configuration = new Configuration.Builder().uri("HTTPS://localhost").build();
        Assertions.assertThat((String)configuration.getDriverClassName()).isEqualTo((Object)"org.neo4j.ogm.drivers.http.driver.HttpDriver");
        Assertions.assertThat((String)configuration.getURI()).isEqualTo((Object)"HTTPS://localhost");
    }

    @Test
    public void shouldParseEmbeddedUriSchemeCaseInsensitive() {
        Configuration configuration = new Configuration.Builder().uri("FILE:///somewhere").build();
        Assertions.assertThat((String)configuration.getDriverClassName()).isEqualTo((Object)"org.neo4j.ogm.drivers.embedded.driver.EmbeddedDriver");
        Assertions.assertThat((String)configuration.getURI()).isEqualTo((Object)"FILE:///somewhere");
    }

    @Test
    public void shouldDefaultToRelaxedQuerying() {
        Configuration.Builder builder = new Configuration.Builder();
        Configuration configuration = builder.build();
        Assertions.assertThat((Boolean)configuration.getUseStrictQuerying()).isFalse();
    }

    @Test
    public void changingQueryingModeShouldWork() {
        Configuration.Builder builder = new Configuration.Builder();
        Configuration configuration = builder.strictQuerying().build();
        Assertions.assertThat((Boolean)configuration.getUseStrictQuerying()).isTrue();
    }

    @Test
    public void shouldParseQUeryingMode() {
        Configuration configuration = new Configuration.Builder(() -> new Properties()).build();
        Assertions.assertThat((Boolean)configuration.getUseStrictQuerying()).isFalse();
        configuration = new Configuration.Builder(() -> {
            Properties properties = new Properties();
            properties.setProperty("use-strict-querying", "");
            return properties;
        }).build();
        Assertions.assertThat((Boolean)configuration.getUseStrictQuerying()).isFalse();
        configuration = new Configuration.Builder(() -> {
            Properties properties = new Properties();
            properties.setProperty("use-strict-querying", "true");
            return properties;
        }).build();
        Assertions.assertThat((Boolean)configuration.getUseStrictQuerying()).isTrue();
        configuration = new Configuration.Builder(() -> {
            Properties properties = new Properties();
            properties.setProperty("use-strict-querying", "false");
            return properties;
        }).build();
        Assertions.assertThat((Boolean)configuration.getUseStrictQuerying()).isFalse();
    }
}

