/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.io.Serializable;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.domain.simple.User;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.TestServer;

@Ignore
public abstract class DriverLazyInitializationTest {
    protected Configuration.Builder configBuilder;

    @Test
    public void shouldCreateSessionFactoryWhenServerIsOffline() throws Exception {
        Configuration configuration = this.configBuilder.build();
        SessionFactory sessionFactory = new SessionFactory(configuration, new String[]{User.class.getPackage().getName()});
        AssertionsForClassTypes.assertThat((Object)sessionFactory.getDriver()).isNotNull();
    }

    @Test(expected=ConnectionException.class)
    public void shouldThrowServiceUnavailableWhenServerIsOfflineAndVerifyIsTrue() throws Exception {
        Configuration configuration = this.configBuilder.verifyConnection(Boolean.valueOf(true)).build();
        new SessionFactory(configuration, new String[]{User.class.getPackage().getName()});
    }

    @Test
    public void shouldInitialiseDriverAfterServerComesOnline() throws Exception {
        TestServer testServer = new TestServer(true, true, 5);
        String uri = testServer.getUri();
        testServer.shutdown();
        Configuration configuration = this.configBuilder.uri(uri).build();
        SessionFactory sessionFactory = new SessionFactory(configuration, new String[]{User.class.getPackage().getName()});
        testServer = new TestServer(false, true, 5, testServer.getPort().intValue());
        Session session = sessionFactory.openSession();
        User user = new User("John Doe");
        session.save((Object)user);
        User loaded = (User)session.load(User.class, (Serializable)user.getId());
        AssertionsForClassTypes.assertThat((String)loaded.getName()).isEqualTo((Object)"John Doe");
    }
}

