/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.context.IdentityMap;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.domain.education.School;
import org.neo4j.ogm.domain.education.Teacher;
import org.neo4j.ogm.domain.education.TeachesAt;
import org.neo4j.ogm.metadata.MetaData;

public class IdentityMapTest {
    private static final MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.education"});
    private static final MappingContext mappingContext = new MappingContext(metaData);

    @Before
    public void setUp() {
        mappingContext.clear();
    }

    @Test
    public void testUnchangedObjectDetected() {
        Teacher mrsJones = new Teacher();
        mrsJones.setId(115L);
        mappingContext.addNodeEntity((Object)mrsJones);
        Assertions.assertThat((boolean)mappingContext.isDirty((Object)mrsJones)).isFalse();
    }

    @Test
    public void testChangedPropertyDetected() {
        Teacher teacher = new Teacher("Miss White");
        teacher.setId(115L);
        mappingContext.addNodeEntity((Object)teacher);
        teacher.setName("Mrs Jones");
        Assertions.assertThat((boolean)mappingContext.isDirty((Object)teacher)).isTrue();
    }

    @Test
    public void testRelatedObjectChangeDoesNotAffectNodeMemoisation() {
        Teacher teacher = new Teacher("Miss White");
        teacher.setId(115L);
        mappingContext.addNodeEntity((Object)teacher);
        teacher.setSchool(new School("Roedean"));
        Assertions.assertThat((boolean)mappingContext.isDirty((Object)teacher)).isFalse();
    }

    @Test
    public void testNodeAndRelationshipWithSameId() {
        Teacher mrsJones = new Teacher();
        mrsJones.setId(1L);
        mappingContext.addNodeEntity((Object)mrsJones);
        TeachesAt teachesAtRelationship = new TeachesAt();
        teachesAtRelationship.setId(1L);
        IdentityMap identityMap = new IdentityMap(metaData);
        identityMap.remember((Object)mrsJones, mrsJones.getId());
        Assertions.assertThat((boolean)identityMap.remembered((Object)mrsJones, mrsJones.getId())).isTrue();
        Assertions.assertThat((boolean)identityMap.remembered((Object)teachesAtRelationship, Long.valueOf(teachesAtRelationship.getId()))).isFalse();
        identityMap.remember((Object)teachesAtRelationship, Long.valueOf(teachesAtRelationship.getId()));
        Assertions.assertThat((boolean)identityMap.remembered((Object)teachesAtRelationship, Long.valueOf(teachesAtRelationship.getId()))).isTrue();
    }
}

