/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilders;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ResponseMapperTest {
    private static final Config driverConfig = Config.build().withoutEncryption().toConfig();
    private static ServerControls serverControls;
    private static URI boltURI;

    @BeforeClass
    public static void initializeNeo4j() throws IOException {
        serverControls = TestServerBuilders.newInProcessBuilder().withProcedure(ApocLovesSwitch.class).newServer();
        boltURI = serverControls.boltURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldIgnoreResultsIfQueryMapsToVoid() {
        try (SessionFactory sessionFactory = null;
             org.neo4j.driver.v1.Driver driver = GraphDatabase.driver((URI)boltURI, (Config)driverConfig);){
            sessionFactory = new SessionFactory((Driver)new BoltDriver(driver), new String[]{ResponseMapperTest.class.getName()});
            Session session = sessionFactory.openSession();
            session.query(Void.TYPE, "CALL apoc.periodic.iterate('MATCH (d:Document) RETURN d',  'SET d.thisIsAProperty = 0' ,{batchSize:200, parallel:false, iterateList:true}) ", new HashMap());
        }
    }

    @AfterClass
    public static void tearDownNeo4j() {
        serverControls.close();
    }

    public static class BatchAndTotalResult {
        public final long batches;
        public final long total;
        public final long timeTaken;

        public BatchAndTotalResult() {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            this.batches = random.nextLong();
            this.total = random.nextLong();
            this.timeTaken = random.nextLong();
        }
    }

    public static class ApocLovesSwitch {
        @Procedure(name="apoc.periodic.iterate", mode=Mode.WRITE)
        public Stream<BatchAndTotalResult> iterate(@Name(value="cypherIterate") String cypherIterate, @Name(value="cypherAction") String cypherAction, @Name(value="config") Map<String, Object> config) {
            return Stream.of(new BatchAndTotalResult());
        }
    }
}

