/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.context.SingleUseEntityMapper;
import org.neo4j.ogm.context.UserResult;
import org.neo4j.ogm.domain.cineasts.minimum.Actor;
import org.neo4j.ogm.domain.cineasts.minimum.Movie;
import org.neo4j.ogm.domain.cineasts.minimum.Role;
import org.neo4j.ogm.domain.cineasts.minimum.SomeQueryResult;
import org.neo4j.ogm.domain.gh391.SomeContainer;
import org.neo4j.ogm.domain.gh551.ThingEntity;
import org.neo4j.ogm.domain.gh551.ThingResult;
import org.neo4j.ogm.domain.gh551.ThingResult2;
import org.neo4j.ogm.domain.gh551.ThingWIthId;
import org.neo4j.ogm.domain.gh552.Thing;
import org.neo4j.ogm.domain.gh777.UserInfo;
import org.neo4j.ogm.domain.gh777.UserSearchDto;
import org.neo4j.ogm.domain.gh813.Container;
import org.neo4j.ogm.domain.gh813.RowModel;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.reflect.ReflectionEntityInstantiator;
import org.neo4j.ogm.session.EntityInstantiator;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class SingleUseEntityMapperTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.gh551", "org.neo4j.ogm.domain.gh391", "org.neo4j.ogm.domain.gh777", "org.neo4j.ogm.domain.cineasts.minimum", "org.neo4j.ogm.domain.gh813"});
        Session session = sessionFactory.openSession();
        session.query("MATCH (n) DETACH DELETE n", Collections.EMPTY_MAP);
        session.query("unwind range(1,10) as x with x create (n:ThingEntity {name: 'Thing ' + x}) return n", Collections.EMPTY_MAP);
        Actor actor = new Actor("A1");
        Movie movie = new Movie("M1");
        Role role = new Role("R1", actor, movie);
        session.save((Object)role);
        movie = new Movie("M2");
        role = new Role("R2", actor, movie);
        session.save((Object)role);
        session.save((Object)new UserInfo("Foo", "Bar", "i@do.com"));
    }

    @Test
    public void gh813() {
        SingleUseEntityMapper entityMapper = new SingleUseEntityMapper(sessionFactory.metaData(), (EntityInstantiator)new ReflectionEntityInstantiator(sessionFactory.metaData()));
        Iterable results = (Iterable)sessionFactory.openSession().query("RETURN 'containerName' AS name, [i IN RANGE(0,3) | {a:{id: i, name:'a'+i}, b:{id: i, name:'b'+i}, c:{id: i, name:'c'+i}}] AS rows", Collections.EMPTY_MAP).queryResults();
        Assertions.assertThat((Iterable)results).hasSize(1);
        Container container = (Container)entityMapper.map(Container.class, (Map)results.iterator().next());
        this.assertContainer(container, 4);
        results = (Iterable)sessionFactory.openSession().query("WITH {a: {id: 0, name: 'a0'}, b: {id:0, name:'b0'}, c: {id:0, name: 'c0'}} AS i RETURN 'containerName' as name, collect(i) as rows", Collections.EMPTY_MAP).queryResults();
        Assertions.assertThat((Iterable)results).hasSize(1);
        container = (Container)entityMapper.map(Container.class, (Map)results.iterator().next());
        this.assertContainer(container, 1);
    }

    private void assertContainer(Container container, int expectedNumberOfRows) {
        Function<Integer, Consumer> rowRequirements = i -> r -> {
            Assertions.assertThat((Integer)r.getA().getId()).isEqualTo(i);
            Assertions.assertThat((String)r.getA().getName()).isEqualTo((Object)("a" + i));
            Assertions.assertThat((Integer)r.getB().getId()).isEqualTo(i);
            Assertions.assertThat((String)r.getB().getName()).isEqualTo((Object)("b" + i));
            Assertions.assertThat((Integer)r.getC().getId()).isEqualTo(i);
            Assertions.assertThat((String)r.getC().getName()).isEqualTo((Object)("c" + i));
        };
        Assertions.assertThat((Object)container).isNotNull();
        Assertions.assertThat((String)container.getName()).isEqualTo((Object)"containerName");
        List<RowModel> rows = container.getRows();
        Assertions.assertThat(rows).hasSize(expectedNumberOfRows);
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            Assertions.assertThat((Object)rows.get(i2)).satisfies(rowRequirements.apply(i2));
        }
    }

    @Test
    public void singleUseEntityMapperShouldWorkWithNullableNestedNodeEntities() {
        SingleUseEntityMapper entityMapper = new SingleUseEntityMapper(sessionFactory.metaData(), (EntityInstantiator)new ReflectionEntityInstantiator(sessionFactory.metaData()));
        Iterable results = (Iterable)sessionFactory.openSession().query("WITH 'a name' AS something OPTIONAL MATCH (t:ThingEntity {na:false}) RETURN something, t as entity", Collections.EMPTY_MAP).queryResults();
        Assertions.assertThat((Iterable)results).hasSize(1);
        ThingResult2 thingResult = (ThingResult2)entityMapper.map(ThingResult2.class, (Map)results.iterator().next());
        Assertions.assertThat((String)thingResult.getSomething()).isEqualTo((Object)"a name");
        Assertions.assertThat((Object)thingResult.getEntity()).isNull();
    }

    @Test
    public void singleUseEntityMapperShouldWorkWithNonNullNestedNodeEntities() {
        SingleUseEntityMapper entityMapper = new SingleUseEntityMapper(sessionFactory.metaData(), (EntityInstantiator)new ReflectionEntityInstantiator(sessionFactory.metaData()));
        Iterable results = (Iterable)sessionFactory.openSession().query("WITH 'a name' AS something OPTIONAL MATCH (t:ThingEntity {name: 'Thing 7'}) RETURN something, t as entity", Collections.EMPTY_MAP).queryResults();
        Assertions.assertThat((Iterable)results).hasSize(1);
        ThingResult2 thingResult = (ThingResult2)entityMapper.map(ThingResult2.class, (Map)results.iterator().next());
        Assertions.assertThat((String)thingResult.getSomething()).isEqualTo((Object)"a name");
        ((AbstractObjectAssert)Assertions.assertThat((Object)thingResult.getEntity()).isNotNull()).extracting(new Function[]{ThingEntity::getName}).containsOnly(new Object[]{"Thing 7"});
    }

    @Test
    public void shouldFailOnIncompatibleProperties() {
        SingleUseEntityMapper entityMapper = new SingleUseEntityMapper(sessionFactory.metaData(), (EntityInstantiator)new ReflectionEntityInstantiator(sessionFactory.metaData()));
        Iterable results = (Iterable)sessionFactory.openSession().query("WITH 'a name' AS something OPTIONAL MATCH (t:ThingEntity) RETURN something, COLLECT(t) as entity", Collections.EMPTY_MAP).queryResults();
        Assertions.assertThat((Iterable)results).hasSize(1);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> {
            ThingResult2 cfr_ignored_0 = (ThingResult2)entityMapper.map(ThingResult2.class, (Map)results.iterator().next());
        }).withMessageContaining("Can not set org.neo4j.ogm.domain.gh551.ThingEntity field org.neo4j.ogm.domain.gh551.ThingResult2.entity to java.util.ArrayList");
    }

    @Test
    public void shouldBeLenientWithSingleValuedCollectionsForSkalarPropertiesMode() {
        SingleUseEntityMapper entityMapper = new SingleUseEntityMapper(sessionFactory.metaData(), (EntityInstantiator)new ReflectionEntityInstantiator(sessionFactory.metaData()));
        Iterable results = (Iterable)sessionFactory.openSession().query("WITH 'a name' AS something OPTIONAL MATCH (t:ThingEntity {name: 'Thing 7'}) RETURN something, COLLECT(t) as entity", Collections.EMPTY_MAP).queryResults();
        Assertions.assertThat((Iterable)results).hasSize(1);
        ThingResult2 thingResult = (ThingResult2)entityMapper.map(ThingResult2.class, (Map)results.iterator().next());
        Assertions.assertThat((String)thingResult.getSomething()).isEqualTo((Object)"a name");
        ((AbstractObjectAssert)Assertions.assertThat((Object)thingResult.getEntity()).isNotNull()).extracting(new Function[]{ThingEntity::getName}).containsOnly(new Object[]{"Thing 7"});
    }

    @Test
    public void singleUseEntityMapperShouldWorkWithNestedObjects() {
        SingleUseEntityMapper entityMapper = new SingleUseEntityMapper(sessionFactory.metaData(), (EntityInstantiator)new ReflectionEntityInstantiator(sessionFactory.metaData()));
        Iterable results = (Iterable)sessionFactory.openSession().query("MATCH (t:ThingEntity) RETURN 'a name' as something, collect({name: t.name}) as things", Collections.EMPTY_MAP).queryResults();
        Assertions.assertThat((Iterable)results).hasSize(1);
        ThingResult thingResult = (ThingResult)entityMapper.map(ThingResult.class, (Map)results.iterator().next());
        Assertions.assertThat((String)thingResult.getSomething()).isEqualTo((Object)"a name");
        Assertions.assertThat((int)thingResult.getThings().size()).isEqualTo(10);
        Assertions.assertThat(thingResult.getThings()).extracting("name").allSatisfy(s -> ((String)s).startsWith("Thing"));
    }

    @Test
    public void queryResultShouldHandleNodeAndRelationshipEntities() {
        SingleUseEntityMapper entityMapper = new SingleUseEntityMapper(sessionFactory.metaData(), (EntityInstantiator)new ReflectionEntityInstantiator(sessionFactory.metaData()));
        for (String query : new String[]{"MATCH (a:Actor {name: 'A1'})-[r:ACTS_IN]->(m:Movie) RETURN a AS actor,COLLECT(r) AS roles, COLLECT(m) as movies", "MATCH (a:Actor {name: 'A1'})-[r:ACTS_IN*]->(m:Movie) RETURN a AS actor,COLLECT(r) AS roles, COLLECT(m) as movies"}) {
            Iterable results = (Iterable)sessionFactory.openSession().query(query, Collections.EMPTY_MAP).queryResults();
            Assertions.assertThat((Iterable)results).hasSize(1);
            SomeQueryResult thingResult = (SomeQueryResult)entityMapper.map(SomeQueryResult.class, (Map)results.iterator().next());
            Assertions.assertThat((String)thingResult.getActor().getName()).isEqualTo((Object)"A1");
            ((IterableAssert)Assertions.assertThat(thingResult.getRoles()).hasSize(2)).extracting(Role::getPlayed).containsExactlyInAnyOrder((Object[])new String[]{"R1", "R2"});
        }
    }

    @Test
    public void shouldUseIdFields() {
        SingleUseEntityMapper entityMapper = new SingleUseEntityMapper(sessionFactory.metaData(), (EntityInstantiator)new ReflectionEntityInstantiator(sessionFactory.metaData()));
        Iterable results = (Iterable)sessionFactory.openSession().query("MATCH (t:ThingEntity) RETURN 4711 as id, 'a name' as name LIMIT 1", Collections.EMPTY_MAP).queryResults();
        Assertions.assertThat((Iterable)results).hasSize(1);
        ThingWIthId thingResult = (ThingWIthId)entityMapper.map(ThingWIthId.class, (Map)results.iterator().next());
        Assertions.assertThat((String)thingResult.getName()).isEqualTo((Object)"a name");
        Assertions.assertThat((Long)thingResult.getId()).isEqualTo(4711L);
    }

    @Test
    public void shouldLookupCorrectRootClass() {
        MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.gh552"});
        String propertyKey = "notAName";
        Map<String, String> properties = Collections.singletonMap(propertyKey, "NOT A NAME!!!");
        SingleUseEntityMapper entityMapper = new SingleUseEntityMapper(metaData, (EntityInstantiator)new ReflectionEntityInstantiator(metaData));
        Thing thing = (Thing)entityMapper.map(Thing.class, properties);
        Assertions.assertThat((String)thing.getNotAName()).isEqualTo((Object)properties.get(propertyKey));
    }

    @Test
    public void shouldDealWithStaticInnerClasses() {
        SingleUseEntityMapper entityMapper = new SingleUseEntityMapper(sessionFactory.metaData(), (EntityInstantiator)new ReflectionEntityInstantiator(sessionFactory.metaData()));
        Iterable results = (Iterable)sessionFactory.openSession().query("MATCH (t:ThingEntity) RETURN 'a name' as something LIMIT 1", Collections.EMPTY_MAP).queryResults();
        Assertions.assertThat((Iterable)results).hasSize(1);
        SomeContainer.StaticInnerThingResult thingResult = (SomeContainer.StaticInnerThingResult)entityMapper.map(SomeContainer.StaticInnerThingResult.class, (Map)results.iterator().next());
        Assertions.assertThat((String)thingResult.getSomething()).isEqualTo((Object)"a name");
    }

    @Test
    public void shouldMapFromMap() {
        MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.context"});
        SingleUseEntityMapper entityMapper = new SingleUseEntityMapper(metaData, (EntityInstantiator)new ReflectionEntityInstantiator(metaData));
        ArrayList<Object> toReturn = new ArrayList<Object>();
        Iterable<Map<String, Object>> results = this.getQueryResults();
        for (Map<String, Object> result : results) {
            toReturn.add(entityMapper.map(UserResult.class, result));
        }
        Assertions.assertThat(toReturn).hasSize(1);
        ((ObjectAssert)Assertions.assertThat(toReturn).first()).isInstanceOf(UserResult.class);
        UserResult userResult = (UserResult)toReturn.iterator().next();
        Assertions.assertThat(userResult.getProfile()).containsAllEntriesOf((Map)results.iterator().next().get("profile"));
    }

    private Iterable<Map<String, Object>> getQueryResults() {
        HashMap<String, String> profile = new HashMap<String, String>();
        profile.put("enterpriseId", "p.enterpriseId");
        profile.put("clidUuid", "u.clidUuid");
        profile.put("profileId", "p.clidUuid");
        profile.put("firstName", "p.firstName");
        profile.put("lastName", "p.lastName");
        profile.put("email", "u.email");
        profile.put("roles", "roles");
        profile.put("connectionType", "connectionType");
        return Collections.singletonList(Collections.singletonMap("profile", profile));
    }

    @Test
    public void assertThatNullOrEmptyObjectsAreMappedCorrectly() {
        SingleUseEntityMapper entityMapper = new SingleUseEntityMapper(sessionFactory.metaData(), (EntityInstantiator)new ReflectionEntityInstantiator(sessionFactory.metaData()));
        Iterable results = (Iterable)sessionFactory.openSession().query("OPTIONAL MATCH (ui:UserInfo {email: 'idontexists@here.com'}) RETURN 4711 AS id, 'infoIsNull' AS status, coalesce(ui, null) as info\nUNION\nOPTIONAL MATCH (ui:UserInfo {email: 'idontexists@either.com'}) RETURN 4712 AS id, 'infoIsEmptyStringApocWhen' AS status, coalesce(ui, '') as info\nUNION\nOPTIONAL MATCH (ui:UserInfo {email: 'i@do.com'}) RETURN 4713 AS id, 'existingMatch' AS status, coalesce(ui, '') as info\n", Collections.EMPTY_MAP).queryResults();
        Assertions.assertThat((Iterable)results).hasSize(3);
        Iterator iterator = results.iterator();
        UserSearchDto userSearchDto = (UserSearchDto)entityMapper.map(UserSearchDto.class, (Map)iterator.next());
        Assertions.assertThat((Long)userSearchDto.getId()).isEqualTo(4711L);
        Assertions.assertThat((String)userSearchDto.getStatus()).isEqualTo((Object)"infoIsNull");
        Assertions.assertThat((Object)userSearchDto.getInfo()).isNull();
        userSearchDto = (UserSearchDto)entityMapper.map(UserSearchDto.class, (Map)iterator.next());
        Assertions.assertThat((Long)userSearchDto.getId()).isEqualTo(4712L);
        Assertions.assertThat((String)userSearchDto.getStatus()).isEqualTo((Object)"infoIsEmptyStringApocWhen");
        Assertions.assertThat((Object)userSearchDto.getInfo()).isNull();
        userSearchDto = (UserSearchDto)entityMapper.map(UserSearchDto.class, (Map)iterator.next());
        Assertions.assertThat((Long)userSearchDto.getId()).isEqualTo(4713L);
        Assertions.assertThat((String)userSearchDto.getStatus()).isEqualTo((Object)"existingMatch");
        Assertions.assertThat((Object)userSearchDto.getInfo()).isNotNull();
        Assertions.assertThat((String)userSearchDto.getInfo().getFirstName()).isEqualTo((Object)"Foo");
        Assertions.assertThat((String)userSearchDto.getInfo().getLastName()).isEqualTo((Object)"Bar");
    }
}

