/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.domain.music.Studio;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class FilterIntegrationTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.music"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
    }

    @After
    public void clear() {
        this.session.purgeDatabase();
    }

    @Test
    public void ignoreCaseShouldNotBeApplicableToComparisonOtherThanEquals() {
        String emi = "EMI Studios, London";
        this.session.save((Object)new Studio("EMI Studios, London"));
        Filter nameFilter = new Filter("name", ComparisonOperator.EQUALS, (Object)"eMi Studios, London").ignoreCase();
        ((IterableAssert)Assertions.assertThat((Iterable)this.session.loadAll(Studio.class, nameFilter, 0)).hasSize(1)).extracting(Studio::getName).containsExactly((Object[])new String[]{"EMI Studios, London"});
    }
}

