/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.context.EntityGraphMapper;
import org.neo4j.ogm.context.EntityMapper;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.cypher.compiler.CompileContext;
import org.neo4j.ogm.cypher.compiler.Compiler;
import org.neo4j.ogm.domain.education.Course;
import org.neo4j.ogm.domain.education.School;
import org.neo4j.ogm.domain.education.Student;
import org.neo4j.ogm.domain.education.Teacher;
import org.neo4j.ogm.domain.forum.Forum;
import org.neo4j.ogm.domain.forum.ForumTopicLink;
import org.neo4j.ogm.domain.forum.Topic;
import org.neo4j.ogm.domain.music.Album;
import org.neo4j.ogm.domain.music.Artist;
import org.neo4j.ogm.domain.restaurant.Branch;
import org.neo4j.ogm.domain.restaurant.Franchise;
import org.neo4j.ogm.domain.restaurant.Location;
import org.neo4j.ogm.domain.restaurant.Restaurant;
import org.neo4j.ogm.domain.social.Individual;
import org.neo4j.ogm.domain.social.Mortal;
import org.neo4j.ogm.domain.travel.Person;
import org.neo4j.ogm.domain.travel.Place;
import org.neo4j.ogm.domain.travel.Visit;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;
import org.neo4j.ogm.session.request.RowStatementFactory;

public class CompilerTest {
    private static MetaData mappingMetadata;
    private static MappingContext mappingContext;
    private EntityMapper mapper;

    @BeforeClass
    public static void setUpTestDatabase() {
        mappingMetadata = new MetaData(new String[]{"org.neo4j.ogm.domain.education", "org.neo4j.ogm.domain.forum", "org.neo4j.ogm.domain.social", "org.neo4j.domain.policy", "org.neo4j.ogm.domain.music", "org.neo4j.ogm.domain.restaurant", "org.neo4j.ogm.domain.travel"});
        mappingContext = new MappingContext(mappingMetadata);
    }

    @Before
    public void setUpMapper() {
        mappingContext = new MappingContext(mappingMetadata);
    }

    @After
    public void cleanGraph() {
        mappingContext.clear();
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowExceptionOnAttemptToMapNullObjectToCypherQuery() {
        this.mapper.map(null);
    }

    @Test
    public void createSingleObjectWithLabelsAndProperties() {
        Student newStudent = new Student("Gary");
        Assertions.assertThat((Long)newStudent.getId()).isNull();
        Compiler compiler = CompilerTest.mapAndCompile(newStudent, -1);
        Assertions.assertThat((boolean)compiler.hasStatementsDependentOnNewNodes()).isFalse();
        Assertions.assertThat((List)compiler.createNodesStatements()).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row CREATE (n:`DomainObject`:`Student`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type"});
    }

    @Test
    public void createSingleStatementForLabelsInDifferentOrder() throws Exception {
        Franchise franchise = new Franchise();
        Restaurant r1 = new Restaurant();
        r1.setName("La Strada Tooting");
        r1.labels = Arrays.asList("Delicious", "Foreign");
        Restaurant r2 = new Restaurant();
        r2.setName("La Strada Brno");
        r2.labels = Arrays.asList("Foreign", "Delicious");
        franchise.addBranch(new Branch(new Location(0.0, 0.0), franchise, r1));
        franchise.addBranch(new Branch(new Location(0.0, 0.0), franchise, r2));
        Compiler compiler = CompilerTest.mapAndCompile(franchise, -1);
        Assertions.assertThat((List)compiler.createNodesStatements()).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row CREATE (n:`Franchise`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type", "UNWIND {rows} as row CREATE (n:`Delicious`:`Foreign`:`Restaurant`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type"});
    }

    @Test
    public void updateSingleObjectPropertyAndLabel() {
        Student sheila = new Student("Sheila Smythe");
        Long sid = 0L;
        sheila.setId(sid);
        mappingContext.addNodeEntity((Object)sheila);
        sheila.setName("Sheila Smythe-Jones");
        Compiler compiler = CompilerTest.mapAndCompile(sheila, -1);
        Assertions.assertThat((boolean)compiler.hasStatementsDependentOnNewNodes()).isFalse();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        Assertions.assertThat((List)compiler.createNodesStatements()).isEmpty();
        Assertions.assertThat((List)compiler.updateNodesStatements()).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (n) WHERE ID(n)=row.nodeId SET n:`DomainObject`:`Student` SET n += row.props RETURN row.nodeId as ref, ID(n) as id, {type} as type"});
    }

    @Test
    public void doNothingIfNothingHasChanged() {
        Long existingNodeId = 0L;
        Student sheila = new Student();
        sheila.setId(existingNodeId);
        sheila.setName("Sheila Smythe");
        mappingContext.addNodeEntity((Object)sheila);
        Compiler compiler = CompilerTest.mapAndCompile(sheila, -1);
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        Assertions.assertThat((List)compiler.createNodesStatements()).isEmpty();
        Assertions.assertThat((List)compiler.updateNodesStatements()).isEmpty();
    }

    @Test
    public void createSimpleRelationshipsBetweenObjects() {
        School waller = new School("Waller");
        Teacher mary = new Teacher("Mary");
        mary.setSchool(waller);
        waller.getTeachers().add(mary);
        Compiler compiler = CompilerTest.mapAndCompile(waller, -1);
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        Assertions.assertThat((boolean)compiler.hasStatementsDependentOnNewNodes()).isTrue();
        Assertions.assertThat((List)compiler.createNodesStatements()).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row CREATE (n:`DomainObject`:`School`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type", "UNWIND {rows} as row CREATE (n:`Teacher`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type"});
        Assertions.assertThat((List)compiler.createRelationshipsStatements()).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`TEACHERS`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type", "UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`SCHOOL`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type"});
    }

    @Test
    public void expectNoChangesWhenDomainUnchanged() {
        Long wallerId = 0L;
        Long maryId = 1L;
        School waller = new School("Waller");
        waller.setId(wallerId);
        Teacher mary = new Teacher("Mary");
        mary.setId(maryId);
        mary.setSchool(waller);
        Assertions.assertThat((boolean)mary.getSchool().equals(waller)).isTrue();
        Assertions.assertThat((boolean)waller.getTeachers().contains(mary)).isTrue();
        Assertions.assertThat((waller.getTeachers().size() == 1 ? 1 : 0) != 0).isTrue();
        mappingContext.addNodeEntity((Object)mary);
        mappingContext.addNodeEntity((Object)waller);
        mappingContext.addRelationship(new MappedRelationship(maryId.longValue(), "SCHOOL", wallerId.longValue(), null, Teacher.class, School.class));
        mappingContext.addRelationship(new MappedRelationship(wallerId.longValue(), "TEACHERS", maryId.longValue(), null, School.class, Teacher.class));
        Compiler compiler = CompilerTest.mapAndCompile(waller, -1);
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        Assertions.assertThat((List)compiler.createNodesStatements()).isEmpty();
        Assertions.assertThat((List)compiler.updateNodesStatements()).isEmpty();
        Assertions.assertThat((List)compiler.createRelationshipsStatements()).isEmpty();
        Assertions.assertThat((List)compiler.updateRelationshipStatements()).isEmpty();
        compiler = CompilerTest.mapAndCompile(mary, -1);
        Assertions.assertThat((List)compiler.createNodesStatements()).isEmpty();
        Assertions.assertThat((List)compiler.updateNodesStatements()).isEmpty();
        Assertions.assertThat((List)compiler.createRelationshipsStatements()).isEmpty();
        Assertions.assertThat((List)compiler.updateRelationshipStatements()).isEmpty();
    }

    @Test
    public void addObjectToExistingCollection() {
        List rows;
        Long wallerId = 0L;
        Long maryId = 1L;
        School waller = new School("Waller");
        waller.setId(wallerId);
        Teacher mary = new Teacher("Mary");
        mary.setId(maryId);
        mary.setSchool(waller);
        Assertions.assertThat((Object)mary.getSchool()).isEqualTo((Object)waller);
        Assertions.assertThat(waller.getTeachers()).contains((Object[])new Teacher[]{mary});
        Assertions.assertThat(waller.getTeachers()).hasSize(1);
        mappingContext.addNodeEntity((Object)mary);
        mappingContext.addNodeEntity((Object)waller);
        mappingContext.addRelationship(new MappedRelationship(maryId.longValue(), "SCHOOL", wallerId.longValue(), null, Teacher.class, School.class));
        mappingContext.addRelationship(new MappedRelationship(wallerId.longValue(), "TEACHERS", maryId.longValue(), null, School.class, Teacher.class));
        Teacher jim = new Teacher("Jim");
        jim.setSchool(waller);
        Assertions.assertThat(waller.getTeachers()).contains((Object[])new Teacher[]{jim});
        Assertions.assertThat(waller.getTeachers()).hasSize(2);
        Assertions.assertThat((Object)jim.getSchool()).isEqualTo((Object)waller);
        Compiler compiler = CompilerTest.mapAndCompile(jim, -1);
        List createNodesStatements = compiler.createNodesStatements();
        Assertions.assertThat((List)createNodesStatements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row CREATE (n:`Teacher`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type"});
        Assertions.assertThat((List)createNodesStatements).extracting(Statement::getParameters);
        for (Statement statement : createNodesStatements) {
            List rows2 = (List)statement.getParameters().get("rows");
            Assertions.assertThat((List)rows2).hasSize(1);
        }
        List createRelsStatements = compiler.createRelationshipsStatements();
        Assertions.assertThat((List)createRelsStatements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`SCHOOL`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type", "UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`TEACHERS`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type"});
        compiler = CompilerTest.mapAndCompile(waller, -1);
        createNodesStatements = compiler.createNodesStatements();
        Assertions.assertThat((List)createNodesStatements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row CREATE (n:`Teacher`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type"});
        for (Statement statement : createNodesStatements) {
            rows = (List)statement.getParameters().get("rows");
            Assertions.assertThat((List)rows).hasSize(1);
        }
        createRelsStatements = compiler.createRelationshipsStatements();
        Assertions.assertThat((List)createRelsStatements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`SCHOOL`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type", "UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`TEACHERS`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type"});
        compiler = CompilerTest.mapAndCompile(mary, -1);
        createNodesStatements = compiler.createNodesStatements();
        Assertions.assertThat((List)createNodesStatements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row CREATE (n:`Teacher`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type"});
        for (Statement statement : createNodesStatements) {
            rows = (List)statement.getParameters().get("rows");
            Assertions.assertThat((List)rows).hasSize(1);
        }
        createRelsStatements = compiler.createRelationshipsStatements();
        Assertions.assertThat((List)createRelsStatements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`SCHOOL`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type", "UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`TEACHERS`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type"});
    }

    @Test
    public void shouldCorrectlyPersistObjectGraphsSeveralLevelsDeep() {
        Student sheila = new Student();
        sheila.setName("Sheila Smythe");
        Student gary = new Student();
        gary.setName("Gary Jones");
        Student winston = new Student();
        winston.setName("Winston Charles");
        Course physics = new Course();
        physics.setName("GCSE Physics");
        physics.setStudents(Arrays.asList(gary, sheila));
        Course maths = new Course();
        maths.setName("A-Level Mathematics");
        maths.setStudents(Arrays.asList(sheila, winston));
        Teacher teacher = new Teacher();
        teacher.setName("Mrs Kapoor");
        teacher.setCourses(Arrays.asList(physics, maths));
        Compiler compiler = CompilerTest.mapAndCompile(teacher, -1);
        List createNodesStatements = compiler.createNodesStatements();
        Assertions.assertThat((List)createNodesStatements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row CREATE (n:`Teacher`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type", "UNWIND {rows} as row CREATE (n:`Course`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type", "UNWIND {rows} as row CREATE (n:`DomainObject`:`Student`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type"});
        for (Statement statement : createNodesStatements) {
            List rows = (List)statement.getParameters().get("rows");
            if (statement.getStatement().contains("Teacher")) {
                Assertions.assertThat((List)rows).hasSize(1);
            }
            if (statement.getStatement().contains("Student")) {
                Assertions.assertThat((List)rows).hasSize(3);
            }
            if (!statement.getStatement().contains("Course")) continue;
            Assertions.assertThat((List)rows).hasSize(2);
        }
        List createRelsStatements = compiler.createRelationshipsStatements();
        Assertions.assertThat((List)createRelsStatements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`COURSES`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type", "UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`STUDENTS`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type"});
        for (Statement statement : createRelsStatements) {
            List rows = (List)statement.getParameters().get("rows");
            if (statement.getStatement().contains("STUDENTS")) {
                Assertions.assertThat((List)rows).hasSize(4);
            }
            if (!statement.getStatement().contains("COURSES")) continue;
            Assertions.assertThat((List)rows).hasSize(2);
        }
    }

    @Test
    public void shouldCorrectlyRemoveRelationshipWhenItemIsRemovedFromCollection() {
        Long mid = 0L;
        Long xid = 1L;
        Long yid = 2L;
        Long zid = 3L;
        Course music = new Course("GCSE Music");
        music.setId(mid);
        Student xavier = new Student("xavier");
        xavier.setId(xid);
        Student yvonne = new Student("Yvonne");
        yvonne.setId(yid);
        Student zack = new Student("Zack");
        zack.setId(zid);
        music.setStudents(Arrays.asList(yvonne, xavier, zack));
        mappingContext.addRelationship(new MappedRelationship(mid.longValue(), "STUDENTS", xid.longValue(), null, Course.class, Student.class));
        mappingContext.addRelationship(new MappedRelationship(mid.longValue(), "STUDENTS", yid.longValue(), null, Course.class, Student.class));
        mappingContext.addRelationship(new MappedRelationship(mid.longValue(), "STUDENTS", zid.longValue(), null, Course.class, Student.class));
        mappingContext.addNodeEntity((Object)xavier);
        mappingContext.addNodeEntity((Object)yvonne);
        mappingContext.addNodeEntity((Object)zack);
        mappingContext.addNodeEntity((Object)music);
        music.setStudents(Arrays.asList(yvonne));
        Compiler compiler = CompilerTest.mapAndCompile(music, -1);
        Assertions.assertThat((List)compiler.createNodesStatements()).isEmpty();
        Assertions.assertThat((List)compiler.createRelationshipsStatements()).isEmpty();
        List deleteRelsStatement = compiler.deleteRelationshipStatements();
        Assertions.assertThat((List)deleteRelsStatement).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MATCH (startNode)-[rel:`STUDENTS`]->(endNode) DELETE rel"});
        Assertions.assertThat((List)((List)((Statement)deleteRelsStatement.get(0)).getParameters().get("rows"))).hasSize(2);
    }

    @Test
    public void shouldCorrectlyRemoveRelationshipWhenItemIsMovedToDifferentCollection() {
        Long teacherId = 0L;
        Long businessStudiesCourseId = 1L;
        Long designTechnologyCourseId = 2L;
        Long shivaniId = 3L;
        Course designTech = new Course("GCSE Design & Technology");
        designTech.setId(designTechnologyCourseId);
        Course businessStudies = new Course("GNVQ Business Studies");
        businessStudies.setId(businessStudiesCourseId);
        Teacher msThompson = new Teacher();
        msThompson.setId(teacherId);
        msThompson.setName("Ms Thompson");
        msThompson.setCourses(Arrays.asList(businessStudies, designTech));
        Student shivani = new Student("Shivani");
        shivani.setId(shivaniId);
        mappingContext.addNodeEntity((Object)msThompson);
        mappingContext.addNodeEntity((Object)businessStudies);
        mappingContext.addNodeEntity((Object)designTech);
        mappingContext.addNodeEntity((Object)shivani);
        mappingContext.addRelationship(new MappedRelationship(teacherId.longValue(), "COURSES", businessStudiesCourseId.longValue(), null, Teacher.class, Course.class));
        mappingContext.addRelationship(new MappedRelationship(teacherId.longValue(), "COURSES", designTechnologyCourseId.longValue(), null, Teacher.class, Course.class));
        mappingContext.addRelationship(new MappedRelationship(businessStudiesCourseId.longValue(), "STUDENTS", shivaniId.longValue(), null, Teacher.class, Student.class));
        businessStudies.setStudents(Collections.emptyList());
        designTech.setStudents(Arrays.asList(shivani));
        Compiler compiler = CompilerTest.mapAndCompile(msThompson, -1);
        List statements = compiler.createNodesStatements();
        Assertions.assertThat((List)statements).isEmpty();
        statements = compiler.createRelationshipsStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`STUDENTS`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type"});
        for (Statement statement : statements) {
            List rows = (List)statement.getParameters().get("rows");
            Assertions.assertThat((List)rows).hasSize(1);
        }
        List deleteRelsStatements = compiler.deleteRelationshipStatements();
        Assertions.assertThat((List)deleteRelsStatements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MATCH (startNode)-[rel:`STUDENTS`]->(endNode) DELETE rel"});
        Assertions.assertThat((List)((List)((Statement)deleteRelsStatements.get(0)).getParameters().get("rows"))).hasSize(1);
    }

    @Test
    public void shouldCorrectlyRemoveRelationshipWhenItemIsDisconnectedFromNonOwningSide() {
        Long schoolId = 0L;
        Long whiteId = 1L;
        Long jonesId = 2L;
        School hillsRoad = new School("Hills Road Sixth Form College");
        hillsRoad.setId(schoolId);
        Teacher mrWhite = new Teacher("Mr White");
        mrWhite.setId(whiteId);
        Teacher missJones = new Teacher("Miss Jones");
        missJones.setId(jonesId);
        hillsRoad.setTeachers(Arrays.asList(missJones, mrWhite));
        Assertions.assertThat(hillsRoad.getTeachers()).contains((Object[])new Teacher[]{mrWhite});
        Assertions.assertThat(hillsRoad.getTeachers()).contains((Object[])new Teacher[]{missJones});
        Assertions.assertThat((Object)mrWhite.getSchool()).isEqualTo((Object)hillsRoad);
        Assertions.assertThat((Object)missJones.getSchool()).isEqualTo((Object)hillsRoad);
        mappingContext.addNodeEntity((Object)hillsRoad);
        mappingContext.addNodeEntity((Object)mrWhite);
        mappingContext.addNodeEntity((Object)missJones);
        mappingContext.addRelationship(new MappedRelationship(schoolId.longValue(), "TEACHERS", whiteId.longValue(), null, School.class, Teacher.class));
        mappingContext.addRelationship(new MappedRelationship(schoolId.longValue(), "TEACHERS", jonesId.longValue(), null, School.class, Teacher.class));
        mappingContext.addRelationship(new MappedRelationship(whiteId.longValue(), "SCHOOL", schoolId.longValue(), null, Teacher.class, School.class));
        mappingContext.addRelationship(new MappedRelationship(jonesId.longValue(), "SCHOOL", schoolId.longValue(), null, Teacher.class, School.class));
        mrWhite.setSchool(null);
        Assertions.assertThat((Object)mrWhite.getSchool()).isNull();
        Assertions.assertThat(hillsRoad.getTeachers()).doesNotContain((Object[])new Teacher[]{mrWhite});
        Compiler compiler = CompilerTest.mapAndCompile(hillsRoad, -1);
        List statements = compiler.createNodesStatements();
        Assertions.assertThat((List)statements).isEmpty();
        statements = compiler.createRelationshipsStatements();
        Assertions.assertThat((List)statements).isEmpty();
        statements = compiler.deleteRelationshipStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MATCH (startNode)-[rel:`TEACHERS`]->(endNode) DELETE rel"});
        Assertions.assertThat((List)((List)((Statement)statements.get(0)).getParameters().get("rows"))).hasSize(1);
        compiler = CompilerTest.mapAndCompile(mrWhite, -1);
        statements = compiler.createNodesStatements();
        Assertions.assertThat((List)statements).isEmpty();
        statements = compiler.createRelationshipsStatements();
        Assertions.assertThat((List)statements).isEmpty();
        statements = compiler.deleteRelationshipStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MATCH (startNode)-[rel:`SCHOOL`]->(endNode) DELETE rel"});
        Assertions.assertThat((List)((List)((Statement)statements.get(0)).getParameters().get("rows"))).hasSize(1);
    }

    @Test
    public void shouldCreateRelationshipWithPropertiesFromRelationshipEntity() {
        List rows;
        Forum forum = new Forum();
        forum.setName("SDN FAQs");
        Topic topic = new Topic();
        ForumTopicLink link = new ForumTopicLink();
        link.setForum(forum);
        link.setTopic(topic);
        link.setTimestamp(1647209L);
        forum.setTopicsInForum(Arrays.asList(link));
        Compiler compiler = CompilerTest.mapAndCompile(forum, -1);
        List statements = compiler.createNodesStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row CREATE (n:`Forum`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type", "UNWIND {rows} as row CREATE (n:`Topic`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type"});
        for (Statement statement : statements) {
            rows = (List)statement.getParameters().get("rows");
            Assertions.assertThat((List)rows).hasSize(1);
        }
        statements = compiler.createRelationshipsStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId CREATE (startNode)-[rel:`HAS_TOPIC`]->(endNode) SET rel += row.props RETURN row.relRef as ref, ID(rel) as id, {type} as type"});
        for (Statement statement : statements) {
            rows = (List)statement.getParameters().get("rows");
            Assertions.assertThat((List)rows).hasSize(1);
        }
        compiler = CompilerTest.mapAndCompile(link, -1);
        statements = compiler.createNodesStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row CREATE (n:`Forum`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type", "UNWIND {rows} as row CREATE (n:`Topic`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type"});
        for (Statement statement : statements) {
            rows = (List)statement.getParameters().get("rows");
            Assertions.assertThat((List)rows).hasSize(1);
        }
        statements = compiler.createRelationshipsStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId CREATE (startNode)-[rel:`HAS_TOPIC`]->(endNode) SET rel += row.props RETURN row.relRef as ref, ID(rel) as id, {type} as type"});
        for (Statement statement : statements) {
            rows = (List)statement.getParameters().get("rows");
            Assertions.assertThat((List)rows).hasSize(1);
        }
        compiler = CompilerTest.mapAndCompile(topic, -1);
        statements = compiler.createNodesStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row CREATE (n:`Topic`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type"});
        for (Statement statement : statements) {
            rows = (List)statement.getParameters().get("rows");
            Assertions.assertThat((List)rows).hasSize(1);
        }
        statements = compiler.createRelationshipsStatements();
        Assertions.assertThat((List)statements).isEmpty();
    }

    @Test
    public void shouldMergeNewRelationshipEntity() throws Exception {
        Person frantisek = new Person("Frantisek");
        Place scotland = new Place("Scotland");
        Visit visit = frantisek.addVisit(scotland, "Holiday");
        Compiler compiler = CompilerTest.mapAndCompile(frantisek, -1);
        List statements = compiler.createRelationshipsStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`VISITED` {`identifier`: row.props.`identifier`}]->(endNode) SET rel += row.props RETURN row.relRef as ref, ID(rel) as id, {type} as type"});
    }

    @Test
    public void shouldUpdatingExistingRelationshipEntity() {
        Long forumId = 0L;
        Long topicId = 1L;
        Long relationshipId = 2L;
        Forum forum = new Forum();
        forum.setId(forumId);
        forum.setName("Spring Data Neo4j");
        Topic topic = new Topic();
        topic.setTopicId(topicId);
        topic.setInActive(Boolean.FALSE);
        ForumTopicLink link = new ForumTopicLink();
        link.setId(relationshipId);
        link.setForum(forum);
        link.setTopic(topic);
        forum.setTopicsInForum(Arrays.asList(link));
        mappingContext.addNodeEntity((Object)forum);
        mappingContext.addNodeEntity((Object)topic);
        mappingContext.addRelationshipEntity((Object)link, relationshipId);
        MappedRelationship mappedRelationship = new MappedRelationship(forumId.longValue(), "HAS_TOPIC", topicId.longValue(), relationshipId, Forum.class, ForumTopicLink.class);
        mappingContext.addRelationship(mappedRelationship);
        link.setTimestamp(327790L);
        Compiler compiler = CompilerTest.mapAndCompile(link, -1);
        List statements = compiler.createNodesStatements();
        Assertions.assertThat((List)statements).isEmpty();
        statements = compiler.updateRelationshipStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} AS row MATCH ()-[r]->() WHERE ID(r) = row.relId SET r += row.props RETURN ID(r) as ref, ID(r) as id, {type} as type"});
        Assertions.assertThat((List)((List)((Statement)statements.get(0)).getParameters().get("rows"))).hasSize(1);
    }

    @Test
    public void shouldDeleteExistingRelationshipEntity() {
        Long forumId = 0L;
        Long topicId = 1L;
        Long linkId = 2L;
        Forum forum = new Forum();
        forum.setId(forumId);
        forum.setName("Spring Data Neo4j");
        Topic topic = new Topic();
        topic.setTopicId(topicId);
        topic.setInActive(Boolean.FALSE);
        ForumTopicLink link = new ForumTopicLink();
        link.setId(linkId);
        link.setForum(forum);
        link.setTopic(topic);
        forum.setTopicsInForum(Arrays.asList(link));
        mappingContext.addNodeEntity((Object)forum);
        mappingContext.addNodeEntity((Object)topic);
        mappingContext.addRelationshipEntity((Object)link, linkId);
        mappingContext.addRelationship(new MappedRelationship(forumId.longValue(), "HAS_TOPIC", topicId.longValue(), null, Forum.class, ForumTopicLink.class));
        forum.setTopicsInForum(null);
        link.setTopic(null);
        Compiler compiler = CompilerTest.mapAndCompile(forum, -1);
        List statements = compiler.createRelationshipsStatements();
        Assertions.assertThat((List)statements).isEmpty();
        statements = compiler.deleteRelationshipStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MATCH (startNode)-[rel:`HAS_TOPIC`]->(endNode) DELETE rel"});
        Assertions.assertThat((List)((List)((Statement)statements.get(0)).getParameters().get("rows"))).hasSize(1);
    }

    @Test
    public void createSimpleRelationshipWithIllegalCharactersBetweenObjects() {
        List rows;
        Artist theBeatles = new Artist("The Beatles");
        Album please = new Album("Please Please Me");
        theBeatles.getAlbums().add(please);
        please.setArtist(theBeatles);
        Compiler compiler = CompilerTest.mapAndCompile(theBeatles, -1);
        List statements = compiler.createNodesStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row CREATE (n:`l'artiste`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type", "UNWIND {rows} as row CREATE (n:`l'album`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type"});
        for (Statement statement : statements) {
            rows = (List)statement.getParameters().get("rows");
            Assertions.assertThat((List)rows).hasSize(1);
        }
        statements = compiler.createRelationshipsStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`HAS-ALBUM`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type"});
        for (Statement statement : statements) {
            rows = (List)statement.getParameters().get("rows");
            Assertions.assertThat((List)rows).hasSize(1);
        }
    }

    @Test
    public void createOutgoingRelationWhenUnmarkedRelationIsSpecified() {
        Individual adam = new Individual();
        adam.setName("Adam");
        Individual vince = new Individual();
        vince.setName("Vince");
        adam.setFriends(Collections.singletonList(vince));
        Compiler compiler = CompilerTest.mapAndCompile(adam, -1);
        List statements = compiler.createNodesStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row CREATE (n:`Individual`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type"});
        for (Statement statement : statements) {
            List rows = (List)statement.getParameters().get("rows");
            Assertions.assertThat((List)rows).hasSize(2);
        }
        statements = compiler.createRelationshipsStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`FRIENDS`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type"});
        List rows = (List)((Statement)statements.get(0)).getParameters().get("rows");
        Assertions.assertThat((List)rows).hasSize(1);
        Map row = (Map)rows.get(0);
        Assertions.assertThat(row.get("startNodeId")).isEqualTo((Object)mappingContext.nativeId((Object)adam));
        Assertions.assertThat(row.get("endNodeId")).isEqualTo((Object)mappingContext.nativeId((Object)vince));
    }

    @Test
    public void createIncomingRelationWhenSpecified() {
        Mortal adam = new Mortal("Adam");
        Mortal vince = new Mortal("Vince");
        adam.getKnownBy().add(vince);
        Compiler compiler = CompilerTest.mapAndCompile(adam, -1);
        List statements = compiler.createNodesStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row CREATE (n:`Mortal`) SET n=row.props RETURN row.nodeRef as ref, ID(n) as id, {type} as type"});
        for (Statement statement : statements) {
            List rows = (List)statement.getParameters().get("rows");
            Assertions.assertThat((List)rows).hasSize(2);
        }
        statements = compiler.createRelationshipsStatements();
        Assertions.assertThat((List)statements).extracting(Statement::getStatement).containsOnly((Object[])new String[]{"UNWIND {rows} as row MATCH (startNode) WHERE ID(startNode) = row.startNodeId WITH row,startNode MATCH (endNode) WHERE ID(endNode) = row.endNodeId MERGE (startNode)-[rel:`KNOWN_BY`]->(endNode) RETURN row.relRef as ref, ID(rel) as id, {type} as type"});
        List rows = (List)((Statement)statements.get(0)).getParameters().get("rows");
        Assertions.assertThat((List)rows).hasSize(1);
        Map row = (Map)rows.get(0);
        Assertions.assertThat(row.get("startNodeId")).isEqualTo((Object)mappingContext.nativeId((Object)vince));
        Assertions.assertThat(row.get("endNodeId")).isEqualTo((Object)mappingContext.nativeId((Object)adam));
    }

    private static Compiler mapAndCompile(Object object, int depth) {
        EntityGraphMapper mapper = new EntityGraphMapper(mappingMetadata, mappingContext);
        CompileContext context = mapper.map(object, depth);
        Compiler compiler = context.getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        return compiler;
    }
}

