/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.context.EntityGraphMapper;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.cypher.compiler.CompileContext;
import org.neo4j.ogm.cypher.compiler.Compiler;
import org.neo4j.ogm.cypher.compiler.MultiStatementCypherCompiler;
import org.neo4j.ogm.cypher.compiler.RelationshipBuilder;
import org.neo4j.ogm.domain.gh609.CyclicNodeType;
import org.neo4j.ogm.domain.gh609.RefField;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.request.StatementFactory;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.request.RowStatementFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.transaction.Transaction;

public class CyclicStructureTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;

    @BeforeClass
    public static void initSesssionFactory() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.gh609"});
    }

    @Test
    public void testCyclicStructure() throws Exception {
        long numberOfNodes = 10L;
        long numberOfRefFields = 100L;
        ArrayList<CyclicNodeType> nodes = new ArrayList<CyclicNodeType>();
        for (long i = 0L; i < numberOfNodes; ++i) {
            nodes.add(new CyclicNodeType());
        }
        ArrayList<RefField> refFields = new ArrayList<RefField>();
        for (long i = 0L; i < numberOfRefFields; ++i) {
            RefField field = new RefField().setNodeTypes(nodes);
            refFields.add(field);
        }
        for (CyclicNodeType nodeType : nodes) {
            nodeType.setSubordinateNodeTypes(nodes);
            nodeType.setRefFields(refFields);
        }
        Session session = sessionFactory.openSession();
        MultiStatementCypherCompiler compiler = (MultiStatementCypherCompiler)CyclicStructureTest.mapAndCompile((Neo4jSession)session, nodes.get(0), -1);
        List<RelationshipBuilder> newRelationshipBuilders = CyclicStructureTest.extractRelationshipBuilder(compiler);
        Assertions.assertThat(newRelationshipBuilders).size().isEqualTo((int)(numberOfNodes * numberOfNodes + numberOfNodes * numberOfRefFields * 2L));
        Transaction transaction = session.beginTransaction();
        session.save(nodes.get(0), -1);
        session.clear();
        transaction.commit();
        session = sessionFactory.openSession();
        Result result = session.query(" MATCH (c1:CyclicNodeType) - [s:SUBORDINATE] - (c2:CyclicNodeType),       (c1) - [f:HAS_FIELD] -> (r:RefField) RETURN count(distinct c1) as numberOfNodes, count(distinct s) as countRelCyc,         count(distinct r)  as numberOfRefFields, count(distinct f) as countRelHasField", Collections.emptyMap());
        Assertions.assertThat((Iterable)result).hasSize(1);
        ((Iterable)result.queryResults()).forEach(record -> {
            Assertions.assertThat(record.get("numberOfNodes")).isEqualTo((Object)numberOfNodes);
            Assertions.assertThat(record.get("numberOfRefFields")).isEqualTo((Object)numberOfRefFields);
            Assertions.assertThat(record.get("countRelCyc")).isEqualTo((Object)(numberOfNodes * numberOfNodes));
            Assertions.assertThat(record.get("countRelHasField")).isEqualTo((Object)(numberOfNodes * numberOfRefFields));
        });
    }

    private static List<RelationshipBuilder> extractRelationshipBuilder(MultiStatementCypherCompiler compiler) throws Exception {
        Field newRelationshipBuildersField = MultiStatementCypherCompiler.class.getDeclaredField("newRelationshipBuilders");
        newRelationshipBuildersField.setAccessible(true);
        return (List)newRelationshipBuildersField.get(compiler);
    }

    private static Compiler mapAndCompile(Neo4jSession session, Object object, int depth) {
        MetaData metaData = session.metaData();
        MappingContext mappingContext = new MappingContext(metaData);
        EntityGraphMapper mapper = new EntityGraphMapper(metaData, mappingContext);
        CompileContext context = mapper.map(object, depth);
        Compiler compiler = context.getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        return compiler;
    }
}

