/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.cineasts.annotated;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.Index;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.typeconversion.Convert;
import org.neo4j.ogm.domain.cineasts.annotated.Knows;
import org.neo4j.ogm.domain.cineasts.annotated.Movie;
import org.neo4j.ogm.domain.cineasts.annotated.Nomination;
import org.neo4j.ogm.domain.cineasts.annotated.Role;
import org.neo4j.ogm.typeconversion.UuidStringConverter;

@NodeEntity
public class Actor {
    @Id
    @GeneratedValue
    private Long id;
    @Convert(value=UuidStringConverter.class)
    @Index(unique=true, primary=true)
    private UUID uuid;
    @Index
    private String name;
    private Set<Movie> filmography;
    @Relationship(type="ACTS_IN", direction="OUTGOING")
    private Set<Role> roles;
    private Set<Nomination> nominations = new HashSet<Nomination>();
    @Relationship(type="KNOWS", direction="OUTGOING")
    public Set<Knows> knows = new HashSet<Knows>();

    Actor() {
    }

    public Actor(String name) {
        this.uuid = UUID.randomUUID();
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public Role playedIn(Movie movie, String roleName) {
        if (this.roles == null) {
            this.roles = new HashSet<Role>();
        }
        Role role = new Role(movie, this, roleName);
        this.roles.add(role);
        movie.getRoles().add(role);
        return role;
    }

    public Nomination nominatedFor(Movie movie, String nominationName, int year) {
        Nomination nomination = new Nomination(movie, this, nominationName, year);
        this.nominations.add(nomination);
        if (movie.getNominations() == null) {
            movie.setNominations(new HashSet<Nomination>());
        }
        movie.getNominations().add(nomination);
        return nomination;
    }

    public String getName() {
        return this.name;
    }

    public Set<Knows> getKnows() {
        return this.knows;
    }

    public Set<Nomination> getNominations() {
        return this.nominations;
    }

    public void setNominations(Set<Nomination> nominations) {
        this.nominations = nominations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Actor actor = (Actor)o;
        if (this.name == null || ((Actor)o).getName() == null) {
            return false;
        }
        return this.name.equals(actor.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String toString() {
        return "Actor {name='" + this.name + '\'' + '}';
    }
}

