/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.cineasts.annotated;

import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.Index;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.typeconversion.Convert;
import org.neo4j.ogm.domain.cineasts.annotated.Pet;
import org.neo4j.ogm.domain.cineasts.annotated.Plays;
import org.neo4j.ogm.domain.cineasts.annotated.Rating;
import org.neo4j.ogm.domain.cineasts.annotated.SecurityRole;
import org.neo4j.ogm.domain.cineasts.annotated.SecurityRoleConverter;
import org.neo4j.ogm.domain.cineasts.annotated.Title;
import org.neo4j.ogm.domain.cineasts.annotated.TitleConverter;
import org.neo4j.ogm.domain.cineasts.annotated.URLArrayConverter;
import org.neo4j.ogm.typeconversion.UuidStringConverter;

@NodeEntity
public class User {
    @Id
    @GeneratedValue
    Long id;
    @Convert(value=UuidStringConverter.class)
    @Index(unique=true)
    private UUID uuid;
    @Index(unique=true, primary=true)
    String login;
    String name;
    String password;
    @Relationship(type="RATED")
    Set<Rating> ratings;
    Set<User> friends;
    @Convert(value=SecurityRoleConverter.class)
    SecurityRole[] securityRoles;
    @Convert(value=TitleConverter.class)
    List<Title> titles;
    @Convert(value=URLArrayConverter.class)
    URL[] urls;
    String[] nicknames;
    @Relationship(value="OWNS")
    List<Pet> pets;
    @Relationship(value="PLAYS")
    List<Plays> plays;

    public User() {
    }

    public User(String login, String name, String password) {
        this.uuid = UUID.randomUUID();
        this.login = login;
        this.name = name;
        this.password = password;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set<Rating> getRatings() {
        return this.ratings;
    }

    public void setRatings(Set<Rating> ratings) {
        this.ratings = ratings;
    }

    public Set<User> getFriends() {
        return this.friends;
    }

    public void setFriends(Set<User> friends) {
        this.friends = friends;
    }

    public SecurityRole[] getSecurityRoles() {
        return this.securityRoles;
    }

    public void setSecurityRoles(SecurityRole[] securityRoles) {
        this.securityRoles = securityRoles;
    }

    public List<Title> getTitles() {
        return this.titles;
    }

    public void setTitles(List<Title> titles) {
        this.titles = titles;
    }

    public URL[] getUrls() {
        return this.urls;
    }

    public void setUrls(URL[] urls) {
        this.urls = urls;
    }

    public String[] getNicknames() {
        return this.nicknames;
    }

    public void setNicknames(String[] nicknames) {
        this.nicknames = nicknames;
    }

    public List<Pet> getPets() {
        return this.pets;
    }

    public void setPets(List<Pet> pets) {
        this.pets = pets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.name != null && user.getName() != null && this.name.equals(user.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return "User:" + this.name;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void addFriends(User ... newFriends) {
        if (this.friends == null) {
            this.friends = new HashSet<User>();
        }
        for (User newFriend : newFriends) {
            this.friends.add(newFriend);
            if (newFriend.friends == null) {
                newFriend.friends = new HashSet<User>();
            }
            newFriend.friends.add(this);
        }
    }
}

