/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.cineasts.minimum;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.domain.cineasts.minimum.Movie;
import org.neo4j.ogm.domain.cineasts.minimum.Role;

public class Actor {
    public Long id;
    String name;
    @Relationship(type="ACTS_IN")
    List<Role> roles = new ArrayList<Role>();

    public Actor() {
    }

    public Actor(String name) {
        this.name = name;
    }

    public void addRole(String character, Movie movie) {
        this.roles.add(new Role(character, this, movie));
    }

    public List<Role> roles() {
        return Collections.unmodifiableList(this.roles);
    }

    public void removeRole(String character) {
        Iterator<Role> iterator = this.roles.iterator();
        while (iterator.hasNext()) {
            Role role = iterator.next();
            if (!role.played.equals(character)) continue;
            iterator.remove();
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }
}

