/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.companies.annotated;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.domain.companies.annotated.Company;
import org.neo4j.ogm.domain.companies.annotated.Device;

public class Person {
    @Id
    @GeneratedValue
    Long id;
    private String name;
    @Relationship(type="EMPLOYEE", direction="OUTGOING")
    private Company employer;
    @Relationship(type="OWNER", direction="OUTGOING")
    private Set<Company> owns;
    @Relationship(type="DEVICE", direction="UNDIRECTED")
    private Set<Device> devices;

    public Person() {
    }

    public Person(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getEmployer() {
        return this.employer;
    }

    public void setEmployer(Company employer) {
        this.employer = employer;
    }

    public Set<Company> getOwns() {
        return this.owns;
    }

    public void setOwns(Set<Company> owns) {
        this.owns = owns;
    }

    public void addDevice(Device device) {
        if (this.devices == null) {
            this.devices = new HashSet<Device>();
        }
        this.devices.add(device);
        device.setPerson(this);
    }

    public void removeDevice(Device device) {
        if (this.devices != null) {
            this.devices.remove(device);
            device.setPerson(null);
        }
    }

    public Set<Device> getDevices() {
        return this.devices;
    }
}

