/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.education;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.ogm.annotation.PostLoad;
import org.neo4j.ogm.domain.education.DomainObject;
import org.neo4j.ogm.domain.education.Teacher;

public class School
extends DomainObject {
    private Set<Teacher> teachers = new HashSet<Teacher>();
    private String name;

    public School() {
    }

    public School(String name) {
        this.setName(name);
    }

    public Set<Teacher> getTeachers() {
        return this.teachers;
    }

    public void setTeachers(Iterable<Teacher> teachers) {
        for (Teacher teacher : teachers) {
            if (this.teachers.contains(teacher)) continue;
            teacher.setSchool(this);
            this.teachers.add(teacher);
        }
    }

    @PostLoad
    public void postLoad() {
        for (Teacher teacher : this.teachers) {
            teacher.setSchool(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

