/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.generic_hierarchy;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.Labels;
import org.neo4j.ogm.annotation.PostLoad;

public abstract class Entity {
    @Id
    protected String uuid;
    @Labels
    protected Set<String> labels = new HashSet<String>();

    public Entity() {
        this.uuid = UUID.randomUUID().toString();
    }

    public Entity(String uuid) {
        this.uuid = uuid;
    }

    @PostLoad
    public void postLoad() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity entity = (Entity)o;
        return Objects.equals(this.uuid, entity.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    public void setLabels(Set<String> labels) {
        this.labels = labels;
    }

    public void addLabel(Object ... labels) {
        for (Object label : labels) {
            this.labels.add(label.toString());
        }
    }

    public void removeLabel(Object ... labels) {
        for (Object label : labels) {
            this.labels.remove(label.toString());
        }
    }
}

