/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.kotlin;

import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Values;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilders;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.domain.dataclasses.MyNode;
import org.neo4j.ogm.domain.dataclasses.OtherNode;
import org.neo4j.ogm.session.SessionFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/neo4j/ogm/domain/kotlin/KotlinInteropTest;", "", "()V", "basicMappingShouldWork", "", "Companion", "neo4j-ogm-test"})
public final class KotlinInteropTest {
    private static ServerControls server;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void basicMappingShouldWork() {
        Configuration.Builder builder = new Configuration.Builder();
        ServerControls serverControls = server;
        if (serverControls == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"server");
        }
        Configuration ogmConfiguration = builder.uri(serverControls.boltURI().toString()).build();
        String[] stringArray = new String[1];
        Package package_ = MyNode.class.getPackage();
        Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"MyNode::class.java.`package`");
        stringArray[0] = package_.getName();
        Ref.ObjectRef myNode = new Ref.ObjectRef();
        try (SessionFactory sessionFactory = new SessionFactory(ogmConfiguration, stringArray);){
            myNode.element = new MyNode(null, "Node1", "A node", CollectionsKt.listOf((Object[])new OtherNode[]{new OtherNode(null, "o1", 1, null), new OtherNode(null, "o2", 1, null)}), 1, null);
            sessionFactory.openSession().save((Object)((MyNode)myNode.element));
            Object object = sessionFactory.openSession().load(MyNode.class, (Serializable)((MyNode)myNode.element).getDbId());
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"sessionFactory.openSessi\u2026:class.java, myNode.dbId)");
            myNode.element = (MyNode)object;
            Assertions.assertThat((String)((MyNode)myNode.element).getName()).isEqualTo((Object)"Node1");
            Assertions.assertThat((String)((MyNode)myNode.element).getDescription()).isEqualTo((Object)"A node");
            ((ListAssert)Assertions.assertThat(((MyNode)myNode.element).getOtherNodes()).hasSize(2)).extracting("name").containsExactlyInAnyOrder(new Object[]{"o1", "o2"});
        }
        ServerControls serverControls2 = server;
        if (serverControls2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"server");
        }
        AutoCloseable autoCloseable = (AutoCloseable)GraphDatabase.driver((URI)serverControls2.boltURI(), (AuthToken)AuthTokens.none());
        boolean bl = false;
        Throwable throwable = null;
        try {
            Driver driver = (Driver)autoCloseable;
            boolean bl2 = false;
            AutoCloseable autoCloseable2 = (AutoCloseable)driver.session();
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                Session session = (Session)autoCloseable2;
                boolean bl4 = false;
                List resultList = session.run("MATCH (n:MyNode) WHERE id(n) = $id RETURN n", Values.parameters((Object[])new Object[]{"id", ((MyNode)myNode.element).getDbId()})).list();
                Assertions.assertThat((List)resultList).hasSize(1);
                List list = resultList;
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"resultList");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Record record = (Record)element$iv;
                    boolean bl5 = false;
                    Assertions.assertThat((Map)record.get("n").asMap()).containsKeys((Object[])new String[]{"name", "description"});
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    static {
        Companion = new Companion(null);
    }

    @BeforeClass
    @JvmStatic
    public static final void setup() {
        Companion.setup();
    }

    @AfterClass
    @JvmStatic
    public static final void tearDown() {
        Companion.tearDown();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0007H\u0007R\u0018\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\t"}, d2={"Lorg/neo4j/ogm/domain/kotlin/KotlinInteropTest$Companion;", "", "()V", "server", "Lorg/neo4j/harness/ServerControls;", "server$annotations", "setup", "", "tearDown", "neo4j-ogm-test"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void server$annotations() {
        }

        @BeforeClass
        @JvmStatic
        public final void setup() {
            ServerControls serverControls = TestServerBuilders.newInProcessBuilder().newServer();
            Intrinsics.checkExpressionValueIsNotNull((Object)serverControls, (String)"TestServerBuilders.newIn\u2026cessBuilder().newServer()");
            server = serverControls;
        }

        @AfterClass
        @JvmStatic
        public final void tearDown() {
            ServerControls serverControls = server;
            if (serverControls == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"server");
            }
            serverControls.close();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

