/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.locking;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.Version;
import org.neo4j.ogm.domain.locking.FriendOf;

@NodeEntity
public class User {
    private Long id;
    private String name;
    @Version
    private Long version;
    @Relationship(type="FRIEND_OF", direction="UNDIRECTED")
    Set<FriendOf> friends = new HashSet<FriendOf>();

    public User() {
    }

    public User(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String toString() {
        return "User{id=" + this.id + ", version=" + this.version + '}';
    }

    public FriendOf addFriend(User user) {
        FriendOf friendOf = new FriendOf(this, user);
        this.friends.add(friendOf);
        user.friends.add(friendOf);
        return friendOf;
    }

    public void addFriend(FriendOf friendOf) {
        this.friends.add(friendOf);
        friendOf.setTo(this);
    }

    public void clearFriends() {
        this.friends.clear();
    }
}

