/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.music;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.domain.music.Album;

@NodeEntity(label="l'artiste")
public class Artist {
    private Long id;
    private String name;
    @Relationship(type="HAS-ALBUM")
    private Set<Album> albums = new HashSet<Album>();
    @Relationship(type="GUEST_ALBUM")
    private Set<Album> guestAlbums = new HashSet<Album>();

    public Artist() {
    }

    public Artist(String name) {
        this.name = name;
    }

    public Set<Album> getAlbums() {
        return this.albums;
    }

    public void setAlbums(Set<Album> albums) {
        this.albums = albums;
        for (Album album : albums) {
            album.setArtist(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Album> getGuestAlbums() {
        return this.guestAlbums;
    }

    public void setGuestAlbums(Set<Album> guestAlbums) {
        this.guestAlbums = guestAlbums;
        for (Album album : guestAlbums) {
            album.setGuestArtist(this);
        }
    }

    public void addAlbum(Album album) {
        this.albums.add(album);
    }

    public Long getId() {
        return this.id;
    }

    public String toString() {
        return "Artist{id=" + this.id + ", name='" + this.name + '\'' + '}';
    }
}

