/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.pizza;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.neo4j.ogm.annotation.Labels;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.domain.pizza.Crust;
import org.neo4j.ogm.domain.pizza.PizzaCheese;
import org.neo4j.ogm.domain.pizza.PizzaSauce;
import org.neo4j.ogm.domain.pizza.PizzaSeasoning;
import org.neo4j.ogm.domain.pizza.Topping;

@NodeEntity(label="Pizza")
public class Pizza {
    private Long id;
    private String name;
    @Relationship(type="FOR", direction="INCOMING")
    private Crust crust;
    @Relationship(type="FOR", direction="INCOMING")
    private List<Topping> toppings;
    @Relationship(type="FOR", direction="INCOMING")
    private PizzaSauce pizzaSauce;
    @Relationship(type="HAS", direction="OUTGOING")
    private Set<PizzaSeasoning> seasonings = new HashSet<PizzaSeasoning>();
    @Relationship(type="HAS", direction="OUTGOING")
    private Set<PizzaCheese> cheeses = new HashSet<PizzaCheese>();
    @Labels
    private List<String> labels = new ArrayList<String>();

    public Pizza() {
    }

    public Pizza(String name) {
        this.name = name;
    }

    public Pizza(String name, Crust crust, List<Topping> toppings) {
        this.name = name;
        this.crust = crust;
        this.toppings = toppings;
    }

    public void addLabel(Object ... labels) {
        for (Object label : labels) {
            this.labels.add(label.toString());
        }
    }

    public void removeLabel(Object ... labels) {
        for (Object label : labels) {
            this.labels.remove(label.toString());
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Crust getCrust() {
        return this.crust;
    }

    public void setCrust(Crust crust) {
        this.crust = crust;
    }

    public List<Topping> getToppings() {
        return this.toppings;
    }

    public void setToppings(List<Topping> toppings) {
        this.toppings = toppings;
    }

    public PizzaSauce getPizzaSauce() {
        return this.pizzaSauce;
    }

    public void setPizzaSauce(PizzaSauce pizzaSauce) {
        this.pizzaSauce = pizzaSauce;
        this.pizzaSauce.setPizza(this);
    }

    public Set<PizzaSeasoning> getSeasonings() {
        return this.seasonings;
    }

    public void setSeasonings(Set<PizzaSeasoning> seasonings) {
        this.seasonings = seasonings;
    }

    public Set<PizzaCheese> getCheeses() {
        return this.cheeses;
    }

    public void setCheeses(Set<PizzaCheese> cheeses) {
        this.cheeses = cheeses;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }
}

