/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.postload;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.ogm.annotation.PostLoad;
import org.neo4j.ogm.annotation.Relationship;

public class User {
    static int postLoadCount = 0;
    Long id;
    @Relationship(type="FRIEND_OF", direction="UNDIRECTED")
    private Set<User> friends;

    public static int getPostLoadCount() {
        return postLoadCount;
    }

    public static void resetPostLoadCount() {
        postLoadCount = 0;
    }

    public Long getId() {
        return this.id;
    }

    @PostLoad
    public void postLoad() {
        ++postLoadCount;
    }

    public Set<User> getFriends() {
        return this.friends;
    }

    public void addFriend(User friend) {
        if (this.friends == null) {
            this.friends = new HashSet<User>();
        }
        this.friends.add(friend);
        if (friend.friends == null) {
            friend.friends = new HashSet<User>();
        }
        friend.friends.add(this);
    }
}

