/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.domain.properties;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Properties;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.domain.properties.Visit;

@NodeEntity
public class User {
    private Long id;
    private String name;
    @Properties
    private Map<String, Object> myProperties;
    @Properties(prefix="myPrefix")
    private Map<String, Object> prefixedProperties;
    @Properties(delimiter="__")
    private Map<String, Object> delimiterProperties;
    @Properties(allowCast=true)
    private Map<String, Integer> integerProperties;
    @Properties(allowCast=true)
    private Map<String, Object> allowCastProperties;
    @Properties
    private Map<EnumA, Object> enumAProperties;
    @Properties
    private Map<EnumB, Object> enumBProperties;
    @Relationship(type="VISITED")
    private Set<Visit> visits;

    public User() {
    }

    public User(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getMyProperties() {
        return this.myProperties;
    }

    public void setMyProperties(Map<String, Object> myProperties) {
        this.myProperties = myProperties;
    }

    public void putMyProperty(String key, Object value) {
        if (this.myProperties == null) {
            this.myProperties = new HashMap<String, Object>();
        }
        this.myProperties.put(key, value);
    }

    public Map<String, Object> getPrefixedProperties() {
        return this.prefixedProperties;
    }

    public void setPrefixedProperties(Map<String, Object> prefixedProperties) {
        this.prefixedProperties = prefixedProperties;
    }

    public void putPrefixedProperty(String key, Object value) {
        if (this.prefixedProperties == null) {
            this.prefixedProperties = new HashMap<String, Object>();
        }
        this.prefixedProperties.put(key, value);
    }

    public Map<String, Object> getDelimiterProperties() {
        return this.delimiterProperties;
    }

    public void setDelimiterProperties(Map<String, Object> delimiterProperties) {
        this.delimiterProperties = delimiterProperties;
    }

    public void putDelimiterProperty(String key, Object value) {
        if (this.delimiterProperties == null) {
            this.delimiterProperties = new HashMap<String, Object>();
        }
        this.delimiterProperties.put(key, value);
    }

    public Map<String, Integer> getIntegerProperties() {
        return this.integerProperties;
    }

    public void setIntegerProperties(Map<String, Integer> integerProperties) {
        this.integerProperties = integerProperties;
    }

    public void putIntegerProperty(String key, Integer value) {
        if (this.integerProperties == null) {
            this.integerProperties = new HashMap<String, Integer>();
        }
        this.integerProperties.put(key, value);
    }

    public Map<String, Object> getAllowCastProperties() {
        return this.allowCastProperties;
    }

    public void setAllowCastProperties(Map<String, Object> allowCastProperties) {
        this.allowCastProperties = allowCastProperties;
    }

    public void putAllowCastProperty(String key, Object value) {
        if (this.allowCastProperties == null) {
            this.allowCastProperties = new HashMap<String, Object>();
        }
        this.allowCastProperties.put(key, value);
    }

    public Set<Visit> getVisits() {
        return this.visits;
    }

    public void setVisits(Set<Visit> visits) {
        this.visits = visits;
    }

    public void addVisit(Visit visit) {
        if (this.visits == null) {
            this.visits = new HashSet<Visit>();
        }
        this.visits.add(visit);
    }

    public Map<EnumA, Object> getEnumAProperties() {
        return this.enumAProperties;
    }

    public void setEnumAProperties(Map<EnumA, Object> enumAProperties) {
        this.enumAProperties = enumAProperties;
    }

    public Map<EnumB, Object> getEnumBProperties() {
        return this.enumBProperties;
    }

    public void setEnumBProperties(Map<EnumB, Object> enumBProperties) {
        this.enumBProperties = enumBProperties;
    }

    public static enum EnumB {
        VALUE_BA;


        public String toString() {
            return super.name() + " deliberately screw the enum combo toString/name.";
        }
    }

    public static enum EnumA {
        VALUE_AA;

    }
}

