/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.neo4j.ogm.config.ObjectMapperFactory;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.exception.ResultProcessingException;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.GraphRowListModel;
import org.neo4j.ogm.model.RestModel;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.request.DefaultRequest;
import org.neo4j.ogm.request.GraphModelRequest;
import org.neo4j.ogm.request.GraphRowListModelRequest;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.request.RestModelRequest;
import org.neo4j.ogm.request.RowModelRequest;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.response.model.DefaultGraphRowListModel;
import org.neo4j.ogm.response.model.DefaultRowModel;
import org.neo4j.ogm.result.ResultGraphModel;
import org.neo4j.ogm.result.ResultRowModel;
import org.neo4j.ogm.transaction.Transaction;

public abstract class StubHttpDriver
extends AbstractConfigurableDriver {
    private final ObjectMapper mapper = ObjectMapperFactory.objectMapper();

    protected abstract String[] getResponse();

    public void close() {
        throw new RuntimeException("not implemented");
    }

    public Request request(Transaction transaction) {
        return new Request(){
            private final String[] json;
            private int count;
            {
                this.json = StubHttpDriver.this.getResponse();
                this.count = 0;
            }

            private String nextRecord() {
                if (this.count < this.json.length) {
                    String r = this.json[this.count];
                    ++this.count;
                    return r;
                }
                return null;
            }

            public Response<GraphModel> execute(GraphModelRequest qry) {
                return new Response<GraphModel>(){

                    public GraphModel next() {
                        String r = this.nextRecord();
                        if (r != null) {
                            try {
                                return ((ResultGraphModel)StubHttpDriver.this.mapper.readValue(r, ResultGraphModel.class)).queryResults();
                            }
                            catch (Exception e) {
                                throw new ResultProcessingException("Could not parse response", e);
                            }
                        }
                        return null;
                    }

                    public void close() {
                    }

                    public String[] columns() {
                        return new String[0];
                    }
                };
            }

            public Response<RowModel> execute(RowModelRequest query) {
                return new Response<RowModel>(){

                    public RowModel next() {
                        String r = this.nextRecord();
                        if (r != null) {
                            try {
                                return new DefaultRowModel(((ResultRowModel)StubHttpDriver.this.mapper.readValue(r, ResultRowModel.class)).queryResults(), this.columns());
                            }
                            catch (Exception e) {
                                throw new ResultProcessingException("Could not parse response", e);
                            }
                        }
                        return null;
                    }

                    public void close() {
                    }

                    public String[] columns() {
                        return new String[0];
                    }
                };
            }

            public Response<RowModel> execute(DefaultRequest query) {
                return null;
            }

            public Response<GraphRowListModel> execute(GraphRowListModelRequest query) {
                return new Response<GraphRowListModel>(){

                    public DefaultGraphRowListModel next() {
                        throw new RuntimeException("not implemented");
                    }

                    public void close() {
                    }

                    public String[] columns() {
                        return new String[0];
                    }
                };
            }

            public Response<RestModel> execute(RestModelRequest query) {
                return null;
            }
        };
    }
}

