/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.driver;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={GraphDatabase.class})
public class BoltDriverConfigurationTest {
    @Before
    public void setup() {
        PowerMockito.mockStatic(GraphDatabase.class, (Class[])new Class[0]);
        Mockito.when((Object)GraphDatabase.routingDriver((Iterable)((Iterable)Mockito.any()), (AuthToken)((AuthToken)Mockito.any()), (Config)((Config)Mockito.any()))).thenAnswer((Answer)Answers.RETURNS_MOCKS);
    }

    @Test
    public void shouldSupportAdditionalRoutingUris() {
        String uri = "bolt+routing://somewhere1";
        String[] uris = new String[]{"bolt+routing://somewhere2", "bolt+routing://somewhere3"};
        List<URI> routingUris = Arrays.asList(URI.create("bolt+routing://somewhere1"), URI.create("bolt+routing://somewhere2"), URI.create("bolt+routing://somewhere3"));
        Configuration configuration = new Configuration.Builder().uri(uri).uris(uris).verifyConnection(Boolean.valueOf(true)).build();
        new SessionFactory(configuration, new String[]{"non.existing.package"});
        Assertions.assertThat((String)configuration.getURI()).isEqualTo((Object)uri);
        Assertions.assertThat((Object[])configuration.getURIS()).isEqualTo((Object)uris);
        PowerMockito.verifyStatic(GraphDatabase.class);
        GraphDatabase.routingDriver((Iterable)((Iterable)Mockito.eq(routingUris)), (AuthToken)((AuthToken)Mockito.any()), (Config)((Config)Mockito.any()));
    }

    @Test
    public void shouldSupportAdditionalRoutingUrisWithoutDefiningUri() {
        String[] uris = new String[]{"bolt+routing://somewhere1", "bolt+routing://somewhere2", "bolt+routing://somewhere3"};
        List<URI> routingUris = Arrays.asList(URI.create("bolt+routing://somewhere1"), URI.create("bolt+routing://somewhere2"), URI.create("bolt+routing://somewhere3"));
        Configuration configuration = new Configuration.Builder().uris(uris).verifyConnection(Boolean.valueOf(true)).build();
        new SessionFactory(configuration, new String[]{"non.existing.package"});
        Assertions.assertThat((Object[])configuration.getURIS()).isEqualTo((Object)uris);
        PowerMockito.verifyStatic(GraphDatabase.class);
        GraphDatabase.routingDriver((Iterable)((Iterable)Mockito.eq(routingUris)), (AuthToken)((AuthToken)Mockito.any()), (Config)((Config)Mockito.any()));
    }

    @Test
    public void shouldCallDefaultGraphDatabaseInstantiationWithJustOneUriInUris() {
        String[] uris = new String[]{"bolt+routing://somewhere1"};
        URI uri = URI.create("bolt+routing://somewhere1");
        Configuration configuration = new Configuration.Builder().uris(uris).verifyConnection(Boolean.valueOf(true)).build();
        new SessionFactory(configuration, new String[]{"non.existing.package"});
        Assertions.assertThat((Object[])configuration.getURIS()).isEqualTo((Object)uris);
        PowerMockito.verifyStatic(GraphDatabase.class);
        GraphDatabase.driver((URI)((URI)Mockito.eq((Object)uri)), (AuthToken)((AuthToken)Mockito.any()), (Config)((Config)Mockito.any()));
    }

    @Test
    public void shouldCallDefaultGraphDatabaseInstantiationWithOneUri() {
        String uriValue = "bolt+routing://somewhere1";
        URI uri = URI.create(uriValue);
        Configuration configuration = new Configuration.Builder().uri(uriValue).verifyConnection(Boolean.valueOf(true)).build();
        new SessionFactory(configuration, new String[]{"non.existing.package"});
        Assertions.assertThat((String)configuration.getURI()).isEqualTo((Object)uriValue);
        PowerMockito.verifyStatic(GraphDatabase.class);
        GraphDatabase.driver((URI)((URI)Mockito.eq((Object)uri)), (AuthToken)((AuthToken)Mockito.any()), (Config)((Config)Mockito.any()));
    }

    @Test
    public void boltDriverJavaDriverInitializationShouldFailIfNoUriOrUrisAreSupplied() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BoltDriver().configure(new Configuration.Builder().verifyConnection(Boolean.valueOf(true)).build())).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("You must provide either an URI or at least one URI in the URIS parameter.");
    }
}

