/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.driver;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Test;
import org.neo4j.driver.internal.value.DateTimeValue;
import org.neo4j.driver.internal.value.FloatValue;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.types.TypeSystem;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.driver.ParameterConversionMode;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.drivers.bolt.driver.JavaDriverBasedParameterConversion;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.testutil.SingleDriverTestClass;

public class JavaBasedParameterConversionTest
extends SingleDriverTestClass {
    @Test
    public void shouldUseNativeTypesWhenNonNativeTypesOnlyIsActive() {
        Assume.assumeTrue((boolean)JavaBasedParameterConversionTest.driverSupportsLocalDate());
        Assume.assumeTrue((boolean)this.databaseSupportJava8TimeTypes());
        HashMap<String, ParameterConversionMode> customConfiguration = new HashMap<String, ParameterConversionMode>();
        customConfiguration.put(ParameterConversionMode.CONFIG_PARAMETER_CONVERSION_MODE, ParameterConversionMode.CONVERT_NON_NATIVE_ONLY);
        try (Driver driver = this.getDriver();){
            BoltDriver boltOgmDriver = new BoltDriver(driver, () -> customConfiguration);
            this.doWithSessionFactoryOf((AbstractConfigurableDriver)boltOgmDriver, new Class[]{JavaBasedParameterConversionTest.class}, sessionFactory -> {
                Session session = sessionFactory.openSession();
                LocalDateTime originalDateTime = LocalDateTime.of(2018, 10, 11, 15, 24);
                HashMap<String, LocalDateTime> parameters = new HashMap<String, LocalDateTime>();
                parameters.put("createdAt", originalDateTime);
                session.query("CREATE (n:Test {createdAt: $createdAt})", parameters);
                Record record = driver.session().run("MATCH (n:Test) RETURN n.createdAt as createdAt").single();
                Object createdAt = record.get("createdAt").asObject();
                ((AbstractObjectAssert)Assertions.assertThat((Object)createdAt).isInstanceOf(LocalDateTime.class)).isEqualTo((Object)originalDateTime);
            });
        }
    }

    private static boolean driverSupportsLocalDate() {
        Class<TypeSystem> t = TypeSystem.class;
        try {
            return t.getDeclaredMethod("LOCAL_DATE_TIME", new Class[0]) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Test
    public void nestedConversions() {
        Assume.assumeTrue((boolean)JavaBasedParameterConversionTest.driverSupportsLocalDate());
        Assume.assumeTrue((boolean)this.databaseSupportJava8TimeTypes());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("aDate", ZonedDateTime.now());
        parameters.put("somethingElse", "Foobar");
        parameters.put("aDouble", 47.11);
        parameters.put("aNumber", new BigDecimal("42.23"));
        parameters.put("listOfDates", Arrays.asList(ZonedDateTime.now()));
        parameters.put("mapOfDates", Collections.singletonMap("aDate", ZonedDateTime.now()));
        parameters.put("arrayOfDates", new ZonedDateTime[]{ZonedDateTime.now()});
        Map convertedParameters = JavaDriverBasedParameterConversion.INSTANCE.convertParameters(parameters);
        Assertions.assertThat(convertedParameters.keySet()).containsAll(parameters.keySet());
        Assertions.assertThat(convertedParameters.get("aDate")).isInstanceOf(DateTimeValue.class);
        ((AbstractObjectAssert)Assertions.assertThat(convertedParameters.get("somethingElse")).isInstanceOf(StringValue.class)).satisfies(v -> {
            AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)Assertions.assertThat((String)((Value)v).asString()).isEqualTo((Object)"Foobar");
        });
        ((AbstractObjectAssert)Assertions.assertThat(convertedParameters.get("aDouble")).isInstanceOf(FloatValue.class)).satisfies(v -> Assertions.assertThat((double)((Value)v).asDouble()).isEqualTo(47.11));
        Assertions.assertThat(convertedParameters.get("aNumber")).isEqualTo((Object)new BigDecimal("42.23"));
        ((AbstractObjectAssert)Assertions.assertThat(convertedParameters.get("listOfDates")).isInstanceOf(ListValue.class)).satisfies(v -> {
            AbstractObjectAssert cfr_ignored_0 = (AbstractObjectAssert)Assertions.assertThat(((Value)v).asList(li -> li).get(0)).isInstanceOf(DateTimeValue.class);
        });
        ((AbstractObjectAssert)Assertions.assertThat(convertedParameters.get("mapOfDates")).isInstanceOf(MapValue.class)).satisfies(v -> {
            AbstractObjectAssert cfr_ignored_0 = (AbstractObjectAssert)Assertions.assertThat(((Value)v).asMap(li -> li).get("aDate")).isInstanceOf(DateTimeValue.class);
        });
        ((AbstractObjectAssert)Assertions.assertThat(convertedParameters.get("arrayOfDates")).isInstanceOf(ListValue.class)).satisfies(v -> {
            AbstractObjectAssert cfr_ignored_0 = (AbstractObjectAssert)Assertions.assertThat(((Value)v).asList(li -> li).get(0)).isInstanceOf(DateTimeValue.class);
        });
    }
}

