/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.bolt.transaction;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.ogm.drivers.bolt.transaction.BoltTransaction;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;

public class BoltTransactionTest {
    @Test
    public void commitShouldCloseTransactionAndSession() {
        Transaction nativeTx = BoltTransactionTest.openTransactionMock();
        Session nativeSession = BoltTransactionTest.openSessionMock(nativeTx);
        BoltTransaction boltTx = new BoltTransaction(BoltTransactionTest.committingTxManager(), nativeSession, Transaction.Type.READ_ONLY);
        boltTx.commit();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{nativeSession, nativeTx});
        ((Transaction)inOrder.verify((Object)nativeTx)).close();
        ((Session)inOrder.verify((Object)nativeSession)).close();
    }

    @Test
    public void commitShouldCloseSessionWhenTransactionIsClosed() {
        Transaction nativeTx = BoltTransactionTest.closedTransactionMock();
        Session nativeSession = BoltTransactionTest.openSessionMock(nativeTx);
        BoltTransaction boltTx = new BoltTransaction(BoltTransactionTest.committingTxManager(), nativeSession, Transaction.Type.READ_ONLY);
        try {
            boltTx.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Transaction)Mockito.verify((Object)nativeTx, (VerificationMode)Mockito.never())).close();
        ((Session)Mockito.verify((Object)nativeSession)).close();
    }

    @Test
    public void commitShouldCloseSessionWhenTransactionCloseThrows() {
        Transaction nativeTx = BoltTransactionTest.openTransactionMock();
        ((Transaction)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Close failed")}).when((Object)nativeTx)).close();
        Session nativeSession = BoltTransactionTest.openSessionMock(nativeTx);
        BoltTransaction boltTx = new BoltTransaction(BoltTransactionTest.committingTxManager(), nativeSession, Transaction.Type.READ_ONLY);
        try {
            boltTx.commit();
            Assertions.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Close failed");
        }
        ((Session)Mockito.verify((Object)nativeSession)).close();
    }

    @Test
    public void rollbackShouldCloseTransactionAndSession() {
        Transaction nativeTx = BoltTransactionTest.openTransactionMock();
        Session nativeSession = BoltTransactionTest.openSessionMock(nativeTx);
        BoltTransaction boltTx = new BoltTransaction(BoltTransactionTest.rollingBackTxManager(), nativeSession, Transaction.Type.READ_ONLY);
        boltTx.rollback();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{nativeSession, nativeTx});
        ((Transaction)inOrder.verify((Object)nativeTx)).close();
        ((Session)inOrder.verify((Object)nativeSession)).close();
    }

    @Test
    public void rollbackShouldCloseSessionWhenTransactionIsClosed() {
        Transaction nativeTx = BoltTransactionTest.closedTransactionMock();
        Session nativeSession = BoltTransactionTest.openSessionMock(nativeTx);
        BoltTransaction boltTx = new BoltTransaction(BoltTransactionTest.rollingBackTxManager(), nativeSession, Transaction.Type.READ_ONLY);
        boltTx.rollback();
        ((Transaction)Mockito.verify((Object)nativeTx, (VerificationMode)Mockito.never())).close();
        ((Session)Mockito.verify((Object)nativeSession)).close();
    }

    @Test
    public void rollbackShouldCloseSessionWhenTransactionCloseThrows() {
        Transaction nativeTx = BoltTransactionTest.openTransactionMock();
        ((Transaction)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Close failed")}).when((Object)nativeTx)).close();
        Session nativeSession = BoltTransactionTest.openSessionMock(nativeTx);
        BoltTransaction boltTx = new BoltTransaction(BoltTransactionTest.rollingBackTxManager(), nativeSession, Transaction.Type.READ_ONLY);
        try {
            boltTx.rollback();
            Assertions.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Close failed");
        }
        ((Session)Mockito.verify((Object)nativeSession)).close();
    }

    private static Session openSessionMock(Transaction nativeTx) {
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)session.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)session.beginTransaction()).thenReturn((Object)nativeTx);
        return session;
    }

    private static Transaction openTransactionMock() {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)tx.isOpen()).thenReturn((Object)true);
        return tx;
    }

    private static Transaction closedTransactionMock() {
        return (Transaction)Mockito.mock(Transaction.class);
    }

    private static TransactionManager committingTxManager() {
        TransactionManager txManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        Mockito.when((Object)txManager.canCommit()).thenReturn((Object)true);
        return txManager;
    }

    private static TransactionManager rollingBackTxManager() {
        TransactionManager txManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        Mockito.when((Object)txManager.canRollback()).thenReturn((Object)true);
        return txManager;
    }
}

